/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.tomcat;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.config.builders.DeployableMuleXmlContextListener;
import org.mule.context.DefaultMuleContextFactory;

public class MuleTomcatListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(MuleTomcatListener.class);
    protected MuleContext muleContext;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"BEFORE_START_EVENT");
            }
            this.doStart();
            return;
        }
        if ("before_stop".equals(event.getType())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"BEFORE_STOP_EVENT");
            }
            this.doStop();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("not our event: " + event.getType()));
        }
    }

    protected void doStart() {
        log.info((Object)"Starting Mule");
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        try {
            this.muleContext = muleContextFactory.createMuleContext();
            this.muleContext.start();
            DeployableMuleXmlContextListener.setMuleContext((MuleContext)this.muleContext);
        }
        catch (Exception e) {
            log.error((Object)"Failed to start Mule", (Throwable)e);
        }
    }

    protected void doStop() {
        log.info((Object)"Stopping Mule");
        try {
            this.muleContext.stop();
        }
        catch (MuleException e) {
            System.err.println("Failed to stop Mule: " + (Object)((Object)e));
        }
        this.muleContext.dispose();
    }
}

