/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.remoting;

import org.mule.api.MuleEventContext;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedExporter;
import org.springframework.remoting.support.RemoteInvocationExecutor;
import org.springframework.remoting.support.RemoteInvocationResult;

public class SpringRemoteInvokerComponent
implements Initialisable,
Callable {
    private Delegate delegate = new Delegate();
    private Class serviceClass;
    private Class serviceInterface;
    private Object serviceBean;
    private boolean registerTraceInterceptor = false;
    private RemoteInvocationExecutor remoteInvocationExecutor;

    public void initialise() throws InitialisationException {
        if (this.serviceClass == null && this.serviceBean == null) {
            throw new InitialisationException(CoreMessages.propertiesNotSet((String)"serviceClass or serviceBean"), (Initialisable)this);
        }
        if (this.serviceInterface == null) {
            throw new InitialisationException(CoreMessages.propertiesNotSet((String)"serviceInterface"), (Initialisable)this);
        }
        if (this.serviceClass != null) {
            Object service = null;
            try {
                service = ClassUtils.instanciateClass((Class)this.serviceClass, null);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
            this.delegate.setService(service);
        } else if (this.serviceBean != null) {
            this.delegate.setService(this.serviceBean);
        }
        this.delegate.setServiceInterface(this.serviceInterface);
        this.delegate.setRegisterTraceInterceptor(this.registerTraceInterceptor);
        if (this.remoteInvocationExecutor != null) {
            this.delegate.setRemoteInvocationExecutor(this.remoteInvocationExecutor);
        }
        this.delegate.afterPropertiesSet();
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public Object getServiceBean() {
        return this.serviceBean;
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public boolean isRegisterTraceInterceptor() {
        return this.registerTraceInterceptor;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    public RemoteInvocationExecutor getRemoteInvocationExecutor() {
        return this.remoteInvocationExecutor;
    }

    public void setRemoteInvocationExecutor(RemoteInvocationExecutor remoteInvocationExecutor) {
        this.remoteInvocationExecutor = remoteInvocationExecutor;
    }

    public Object onCall(MuleEventContext eventContext) throws Exception {
        Object transformedMessage = eventContext.transformMessage();
        RemoteInvocation ri = (RemoteInvocation)transformedMessage;
        Object rval = this.delegate.execute(ri);
        return rval;
    }

    private class Delegate
    extends RemoteInvocationBasedExporter
    implements InitializingBean {
        private Object proxy;

        private Delegate() {
        }

        public void afterPropertiesSet() {
            this.proxy = this.getProxyForService();
        }

        public Object execute(RemoteInvocation invocation) {
            try {
                Object value = this.invoke(invocation, this.proxy);
                return value;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return new RemoteInvocationResult(ex);
            }
        }
    }
}

