/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.processors;

import org.mule.api.NameableObject;
import org.mule.api.agent.Agent;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class MuleObjectNameProcessor
implements BeanPostProcessor {
    private boolean overwrite = false;
    private final Class<? extends NameableObject>[] managedTypes = new Class[]{Connector.class, Transformer.class, Service.class, Model.class, Agent.class};

    public Object postProcessBeforeInitialization(Object object, String beanName) throws BeansException {
        for (Class<? extends NameableObject> managedType : this.managedTypes) {
            if (!managedType.isInstance(object)) continue;
            this.setNameIfNecessary((NameableObject)object, beanName);
        }
        return object;
    }

    private void setNameIfNecessary(NameableObject nameable, String name) {
        if (nameable.getName() == null || this.overwrite) {
            nameable.setName(name);
        }
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        return o;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

