/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowRefFactoryBean
implements FactoryBean<MessageProcessor>,
ApplicationContextAware,
MuleContextAware,
Initialisable {
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;
    private MessageProcessor referencedMessageProcessor;

    public void setName(String name) {
        this.refName = name;
    }

    public void initialise() throws InitialisationException {
        if (this.refName.isEmpty()) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"flow reference is empty"), (Initialisable)this);
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.refName)) {
            this.referencedMessageProcessor = this.getReferencedMessageProcessor(this.refName);
        }
    }

    public MessageProcessor getObject() throws Exception {
        if (this.referencedMessageProcessor != null) {
            return this.referencedMessageProcessor;
        }
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                MessageProcessor dynamicMessageProcessor = FlowRefFactoryBean.this.getReferencedMessageProcessor(FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event));
                return dynamicMessageProcessor.process(event);
            }
        };
    }

    protected MessageProcessor getReferencedMessageProcessor(String name) {
        final MessageProcessor processor = (MessageProcessor)this.applicationContext.getBean(name);
        if (processor == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (processor instanceof FlowConstruct) {
            return new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    return processor.process(event);
                }
            };
        }
        return processor;
    }

    public boolean isSingleton() {
        return false;
    }

    public Class<?> getObjectType() {
        return MessageProcessor.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

