/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.generic;

import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssembler;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.assembly.configuration.SingleProperty;
import org.mule.config.spring.parsers.generic.ParentDefinitionParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class NameTransferDefinitionParser
extends ParentDefinitionParser {
    private String name;
    private String componentAttributeValue;
    private String componentAttributeName;

    public NameTransferDefinitionParser(String componentAttributeName) {
        this.componentAttributeName = componentAttributeName;
        this.setBeanAssemblerFactory(new LocalBeanAssemblerFactory());
    }

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.name = null;
        this.componentAttributeValue = null;
        AbstractBeanDefinition bd = super.parseInternal(element, parserContext);
        element.removeAttribute("name");
        return bd;
    }

    private void setName() {
        BeanDefinition beanDef = this.getParserContext().getRegistry().getBeanDefinition(this.componentAttributeValue);
        MutablePropertyValues propertyValues = beanDef.getPropertyValues();
        if (!propertyValues.contains("name")) {
            this.logger.debug((Object)("Setting name on " + this.componentAttributeValue + " to " + this.name));
            propertyValues.addPropertyValue("name", (Object)this.name);
        } else {
            this.logger.debug((Object)("Not setting name on " + this.componentAttributeValue + " as already " + propertyValues.getPropertyValue("name")));
        }
    }

    private class LocalBeanAssemblerFactory
    implements BeanAssemblerFactory {
        private LocalBeanAssemblerFactory() {
        }

        @Override
        public BeanAssembler newBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            return new LocalBeanAssembler(beanConfig, bean, targetConfig, target);
        }
    }

    private class LocalBeanAssembler
    extends DefaultBeanAssembler {
        public LocalBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            super(beanConfig, bean, targetConfig, target);
        }

        @Override
        protected void addPropertyWithReference(MutablePropertyValues properties, SingleProperty config, String name, Object value) {
            if ("name".equals(name) && value instanceof String) {
                NameTransferDefinitionParser.this.name = (String)value;
                if (null != NameTransferDefinitionParser.this.componentAttributeValue) {
                    NameTransferDefinitionParser.this.setName();
                }
            } else {
                super.addPropertyWithReference(properties, config, name, value);
                if (NameTransferDefinitionParser.this.componentAttributeName.equals(name) && value instanceof String) {
                    NameTransferDefinitionParser.this.componentAttributeValue = (String)value;
                    if (null != NameTransferDefinitionParser.this.name) {
                        NameTransferDefinitionParser.this.setName();
                    }
                }
            }
        }
    }
}

