/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.util.List;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssembler;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.generic.ParentDefinitionParser;
import org.mule.routing.MessageFilter;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.w3c.dom.Element;

public class FilterRefDefinitionParser
extends ParentDefinitionParser {
    public static final String FILTER = "filter";
    private String ref;

    @Override
    protected void preProcess(Element element) {
        super.preProcess(element);
        if (this.isWrapWithMessageFilter(element)) {
            this.setBeanAssemblerFactory(new MessageProcessorWrappingBeanAssemblerFactory());
            this.addAlias("ref", "messageProcessor");
        } else {
            this.setBeanAssemblerFactory(new DefaultBeanAssemblerFactory());
            this.addAlias("ref", FILTER);
        }
    }

    private boolean isWrapWithMessageFilter(Element e) {
        String parentName = e.getParentNode().getLocalName().toLowerCase();
        String grandParentName = e.getParentNode().getParentNode().getLocalName().toLowerCase();
        return !"message-filter".equals(parentName) && !"and-filter".equals(parentName) && !"or-filter".equals(parentName) && !"not-filter".equals(parentName) && !"outbound".equals(grandParentName) && !"selective-consumer-router".equals(parentName) && !"error-filter".equals(parentName);
    }

    private static class MessageProcessorWrappingBeanAssembler
    extends DefaultBeanAssembler {
        public MessageProcessorWrappingBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            super(beanConfig, bean, targetConfig, target);
        }

        @Override
        public void copyBeanToTarget() {
            Object oldValue;
            String oldName = "messageProcessor";
            this.assertTargetPresent();
            String newName = MessageProcessorWrappingBeanAssembler.bestGuessName(this.targetConfig, oldName, this.target.getBeanClassName());
            MutablePropertyValues targetProperties = this.target.getPropertyValues();
            MutablePropertyValues beanProperties = this.bean.getBeanDefinition().getPropertyValues();
            RuntimeBeanReference ref = (RuntimeBeanReference)((ManagedList)beanProperties.getPropertyValue(newName).getValue()).get(0);
            BeanDefinitionBuilder messageFilter = BeanDefinitionBuilder.genericBeanDefinition(MessageFilter.class);
            messageFilter.addPropertyValue(FilterRefDefinitionParser.FILTER, (Object)ref);
            PropertyValue pv = targetProperties.getPropertyValue(newName);
            Object object = oldValue = null == pv ? null : pv.getValue();
            if (oldValue == null) {
                oldValue = new ManagedList();
                pv = new PropertyValue(newName, oldValue);
                targetProperties.addPropertyValue(pv);
            }
            if (this.targetConfig.isCollection(oldName)) {
                List list = MessageProcessorWrappingBeanAssembler.retrieveList(oldValue);
                list.add(messageFilter.getBeanDefinition());
            } else {
                targetProperties.addPropertyValue(newName, (Object)messageFilter.getBeanDefinition());
            }
        }
    }

    private static class MessageProcessorWrappingBeanAssemblerFactory
    implements BeanAssemblerFactory {
        private MessageProcessorWrappingBeanAssemblerFactory() {
        }

        @Override
        public BeanAssembler newBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            return new MessageProcessorWrappingBeanAssembler(beanConfig, bean, targetConfig, target);
        }
    }
}

