/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.NamedObject;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.processor.AsyncDelegateMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.util.concurrent.ThreadNameHelper;
import org.springframework.beans.factory.FactoryBean;

public class AsyncMessageProcessorsFactoryBean
implements FactoryBean,
MuleContextAware,
NamedObject {
    protected MuleContext muleContext;
    protected List messageProcessors;
    protected ThreadingProfile threadingProfile;
    protected String name;

    public Class getObjectType() {
        return MessageProcessor.class;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public Object getObject() throws Exception {
        if (this.threadingProfile == null) {
            this.threadingProfile = this.muleContext.getDefaultThreadingProfile();
        }
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'async' child chain");
        MuleConfiguration config = this.muleContext.getConfiguration();
        String threadPrefix = ThreadNameHelper.asyncProcessor((MuleContext)this.muleContext, (String)this.name);
        AsyncDelegateMessageProcessor asyncProcessor = new AsyncDelegateMessageProcessor(this.threadingProfile, threadPrefix, config.getShutdownTimeout());
        for (Object processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{(MessageProcessor)processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        asyncProcessor.setDelegate((MessageProcessor)builder.build());
        return asyncProcessor;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

