/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.SpringRegistryLifecycleManager;
import org.mule.lifecycle.RegistryLifecycleManager;
import org.mule.registry.AbstractRegistry;
import org.mule.util.StringUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringRegistry
extends AbstractRegistry {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    public static final String SPRING_APPLICATION_CONTEXT = "springApplicationContext";
    protected ApplicationContext applicationContext;
    protected AtomicBoolean springContextInitialised = new AtomicBoolean(false);

    public SpringRegistry(MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
    }

    public SpringRegistry(String id, MuleContext muleContext) {
        super(id, muleContext);
    }

    public SpringRegistry(ApplicationContext applicationContext, MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
        this.applicationContext = applicationContext;
    }

    public SpringRegistry(String id, ApplicationContext applicationContext, MuleContext muleContext) {
        super(id, muleContext);
        this.applicationContext = applicationContext;
    }

    public SpringRegistry(ConfigurableApplicationContext applicationContext, ApplicationContext parentContext, MuleContext muleContext) {
        super(REGISTRY_ID, muleContext);
        applicationContext.setParent(parentContext);
        this.applicationContext = applicationContext;
    }

    public SpringRegistry(String id, ConfigurableApplicationContext applicationContext, ApplicationContext parentContext, MuleContext muleContext) {
        super(id, muleContext);
        applicationContext.setParent(parentContext);
        this.applicationContext = applicationContext;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).refresh();
        }
        this.springContextInitialised.set(true);
    }

    public void doDispose() {
        if (!this.springContextInitialised.get()) {
            return;
        }
        if (this.applicationContext instanceof ConfigurableApplicationContext && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
        this.applicationContext = null;
        this.springContextInitialised.set(false);
    }

    protected RegistryLifecycleManager createLifecycleManager() {
        return new SpringRegistryLifecycleManager(this.getRegistryId(), (Registry)this, this.muleContext);
    }

    public Object lookupObject(String key) {
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn((Object)MessageFactory.createStaticMessage((String)"Detected a lookup attempt with an empty or null key"), new Throwable().fillInStackTrace());
            return null;
        }
        if (key.equals(SPRING_APPLICATION_CONTEXT) && this.applicationContext != null) {
            return this.applicationContext;
        }
        try {
            return this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug((Object)e);
            return null;
        }
    }

    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.lookupByType(type).values();
    }

    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.internalLookupByType(type, false, false).values();
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.internalLookupByType(type, true, true);
    }

    protected <T> Map<String, T> internalLookupByType(Class<T> type, boolean nonSingletons, boolean eagerInit) {
        try {
            return this.applicationContext.getBeansOfType(type, nonSingletons, eagerInit);
        }
        catch (FatalBeanException fbex) {
            String message = String.format("Failed to lookup beans of type %s from the Spring registry", type);
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)message), (Throwable)fbex);
        }
        catch (Exception e) {
            this.logger.debug((Object)e);
            return Collections.emptyMap();
        }
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void registerObjects(Map objects) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void unregisterObject(String key) {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }
}

