/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.util.HashMap;
import java.util.Map;
import org.mule.component.DefaultJavaComponent;
import org.mule.config.spring.parsers.specific.ComponentDefinitionParser;
import org.mule.object.SingletonObjectFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SimpleComponentDefinitionParser
extends ComponentDefinitionParser {
    private static Class OBJECT_FACTORY_TYPE = SingletonObjectFactory.class;
    private Class componentInstanceClass;
    private Map properties = new HashMap();

    public SimpleComponentDefinitionParser(Class component, Class componentInstanceClass) {
        super(DefaultJavaComponent.class);
        this.componentInstanceClass = componentInstanceClass;
    }

    protected void preProcess(Element element) {
        super.preProcess(element);
        NamedNodeMap attrs = element.getAttributes();
        int numAttrs = attrs.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            Node attr = attrs.item(i);
            this.properties.put(attr.getNodeName(), attr.getNodeValue());
            attrs.removeNamedItem(attr.getNodeName());
        }
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element parent = (Element)element.getParentNode();
        String serviceName = parent.getAttribute("name");
        builder.addPropertyReference("service", serviceName);
        builder.addDependsOn(serviceName);
        builder.addPropertyValue("objectFactory", (Object)this.getObjectFactoryDefinition(element));
        super.parseChild(element, parserContext, builder);
    }

    protected AbstractBeanDefinition getObjectFactoryDefinition(Element element) {
        GenericBeanDefinition objectFactoryBeanDefinition = new GenericBeanDefinition();
        objectFactoryBeanDefinition.setBeanClass(OBJECT_FACTORY_TYPE);
        objectFactoryBeanDefinition.getPropertyValues().addPropertyValue("objectClass", (Object)this.componentInstanceClass);
        objectFactoryBeanDefinition.getPropertyValues().addPropertyValue("properties", (Object)this.properties);
        objectFactoryBeanDefinition.setInitMethodName("initialise");
        objectFactoryBeanDefinition.setDestroyMethodName("dispose");
        return objectFactoryBeanDefinition;
    }
}

