/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.hotdeploy;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.config.ConfigResource;
import org.mule.config.StartupContext;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.config.spring.hotdeploy.DefaultMuleSharedDomainClassLoader;
import org.mule.config.spring.hotdeploy.FileWatcher;
import org.mule.config.spring.hotdeploy.MuleApplicationClassLoader;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.module.boot.MuleBootstrapUtils;

public class ReloadableBuilder
extends SpringXmlConfigurationBuilder {
    protected static final ClassLoader CLASSLOADER_ROOT = Thread.currentThread().getContextClassLoader();
    protected static final URL[] CLASSPATH_EMPTY = new URL[0];
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected File monitoredResource;
    protected static final int RELOAD_INTERVAL_MS = 3000;

    public ReloadableBuilder(ConfigResource[] configResources) {
        super(configResources);
    }

    public ReloadableBuilder(String s) throws ConfigurationException {
        super(s);
    }

    public ReloadableBuilder(String[] strings) throws ConfigurationException {
        super(strings);
    }

    public void configure(final MuleContext muleContext) throws ConfigurationException {
        boolean redeploymentEnabled = !StartupContext.get().getStartupOptions().containsKey("production");
        try {
            ConfigResource[] allResources;
            if (this.useDefaultConfigResource) {
                allResources = new ConfigResource[this.configResources.length + 1];
                allResources[0] = new ConfigResource("default-mule-config.xml");
                System.arraycopy(this.configResources, 0, allResources, 1, this.configResources.length);
            } else {
                allResources = this.configResources;
            }
            this.monitoredResource = new File(allResources[1].getUrl().getFile());
            ClassLoader parent = MuleBootstrapUtils.isStandalone() ? new DefaultMuleSharedDomainClassLoader(CLASSLOADER_ROOT) : CLASSLOADER_ROOT;
            MuleApplicationClassLoader cl = new MuleApplicationClassLoader(this.monitoredResource, parent);
            Thread.currentThread().setContextClassLoader(cl);
            if (redeploymentEnabled && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Monitoring for hot-reload: " + this.monitoredResource));
            }
            FileWatcher watcher = new FileWatcher(this.monitoredResource){
                private volatile boolean cancelled;

                protected synchronized void onChange(File file) {
                    if (this.cancelled) {
                        return;
                    }
                    this.cancel();
                    this.cancelled = true;
                    if (ReloadableBuilder.this.logger.isInfoEnabled()) {
                        ReloadableBuilder.this.logger.info((Object)("================== Reloading " + file));
                    }
                    try {
                        muleContext.dispose();
                        Thread.currentThread().setContextClassLoader(null);
                        ClassLoader parent = MuleBootstrapUtils.isStandalone() ? new DefaultMuleSharedDomainClassLoader(CLASSLOADER_ROOT) : CLASSLOADER_ROOT;
                        MuleApplicationClassLoader cl = new MuleApplicationClassLoader(ReloadableBuilder.this.monitoredResource, parent);
                        Thread.currentThread().setContextClassLoader(cl);
                        DefaultMuleContextFactory f = new DefaultMuleContextFactory();
                        MuleContext newContext = f.createMuleContext((ConfigurationBuilder)ReloadableBuilder.this);
                        ReloadableBuilder.this.doConfigure(newContext);
                        newContext.start();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            if (redeploymentEnabled) {
                Timer timer = new Timer();
                int reloadIntervalMs = 3000;
                timer.schedule((TimerTask)watcher, new Date(), 3000L);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Reload interval: 3000");
                }
            }
            super.configure(muleContext);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ConfigResource[] allResources;
        if (this.useDefaultConfigResource) {
            allResources = new ConfigResource[this.configResources.length + 1];
            allResources[0] = new ConfigResource("default-mule-config.xml");
            System.arraycopy(this.configResources, 0, allResources, 1, this.configResources.length);
        } else {
            allResources = this.configResources;
        }
        this.createSpringRegistry(muleContext, this.createApplicationContext(muleContext, allResources));
    }
}

