/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.component.DefaultJavaComponent;
import org.mule.config.spring.parsers.specific.ComponentDefinitionParser;
import org.mule.object.SingletonObjectFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SimpleComponentDefinitionParser
extends ComponentDefinitionParser {
    private static Class OBJECT_FACTORY_TYPE = SingletonObjectFactory.class;
    private Class componentInstanceClass;

    public SimpleComponentDefinitionParser(Class component, Class componentInstanceClass) {
        super(DefaultJavaComponent.class);
        this.componentInstanceClass = componentInstanceClass;
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element parent = (Element)element.getParentNode();
        String serviceName = parent.getAttribute("name");
        builder.addPropertyReference("service", serviceName);
        GenericBeanDefinition objectFactoryBeanDefinition = new GenericBeanDefinition();
        objectFactoryBeanDefinition.setBeanClass(OBJECT_FACTORY_TYPE);
        objectFactoryBeanDefinition.getPropertyValues().addPropertyValue("objectClass", (Object)this.componentInstanceClass);
        objectFactoryBeanDefinition.setInitMethodName("initialise");
        objectFactoryBeanDefinition.setDestroyMethodName("dispose");
        builder.addPropertyValue("objectFactory", (Object)objectFactoryBeanDefinition);
        super.parseChild(element, parserContext, builder);
    }
}

