/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Collection;
import java.util.Map;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.lifecycle.GenericLifecycleManager;
import org.mule.registry.AbstractRegistry;
import org.mule.util.CollectionUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringRegistry
extends AbstractRegistry {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    public static final String SPRING_APPLICATION_CONTEXT = "springApplicationContext";
    protected ApplicationContext applicationContext;

    public SpringRegistry() {
        super(REGISTRY_ID);
    }

    public SpringRegistry(String id) {
        super(id);
    }

    public SpringRegistry(ApplicationContext applicationContext) {
        super(REGISTRY_ID);
        this.applicationContext = applicationContext;
    }

    public SpringRegistry(String id, ApplicationContext applicationContext) {
        super(id);
        this.applicationContext = applicationContext;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).refresh();
        }
    }

    protected void doDispose() {
        if (this.applicationContext instanceof ConfigurableApplicationContext && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
    }

    protected LifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        lcm.registerLifecycle((LifecyclePhase)new ContainerManagedLifecyclePhase("initialise", Initialisable.class, "dispose"));
        lcm.registerLifecycle((LifecyclePhase)new ContainerManagedLifecyclePhase("dispose", Disposable.class, "initialise"));
        return lcm;
    }

    public Object lookupObject(String key) {
        if (StringUtils.isBlank((String)key)) {
            this.logger.warn((Object)MessageFactory.createStaticMessage((String)"Detected a lookup attempt with an empty or null key"), new Throwable().fillInStackTrace());
            return null;
        }
        if (key.equals(SPRING_APPLICATION_CONTEXT) && this.applicationContext != null) {
            return this.applicationContext;
        }
        try {
            return this.applicationContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug((Object)e);
            return null;
        }
    }

    public Collection lookupObjects(Class type) {
        try {
            Map map = this.applicationContext.getBeansOfType(type);
            return map.values();
        }
        catch (Exception e) {
            this.logger.debug((Object)e);
            return CollectionUtils.EMPTY_COLLECTION;
        }
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void registerObjects(Map objects) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void unregisterObject(String key) {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }
}

