/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.Registry;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.config.spring.SpringRegistry;
import org.springframework.context.ApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder {
    public static final String MULE_DEFAULTS_CONFIG = "default-mule-config.xml";
    private boolean useDefaultConfigResource = true;
    private Registry registry;

    public SpringXmlConfigurationBuilder(String[] configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(String configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources) {
        super(configResources);
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ConfigResource[] allResources;
        if (this.useDefaultConfigResource) {
            allResources = new ConfigResource[this.configResources.length + 1];
            allResources[0] = new ConfigResource(MULE_DEFAULTS_CONFIG);
            System.arraycopy(this.configResources, 0, allResources, 1, this.configResources.length);
        } else {
            allResources = this.configResources;
        }
        this.createSpringRegistry(muleContext, this.createApplicationContext(muleContext, allResources));
    }

    protected ApplicationContext createApplicationContext(MuleContext muleContext, ConfigResource[] configResources) throws Exception {
        return new MuleApplicationContext(muleContext, configResources);
    }

    protected void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        this.registry = new SpringRegistry(applicationContext);
        muleContext.addRegistry(1L, this.registry);
        this.registry.initialise();
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.applyPhase(this.registry.lookupObjects(Object.class), "start");
        }
    }

    public boolean isUseDefaultConfigResource() {
        return this.useDefaultConfigResource;
    }

    public void setUseDefaultConfigResource(boolean useDefaultConfigResource) {
        this.useDefaultConfigResource = useDefaultConfigResource;
    }
}

