/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import org.mule.config.spring.parsers.AbstractHierarchicalDefinitionParser;
import org.mule.config.spring.parsers.MuleChildDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractChildDefinitionParser
extends AbstractHierarchicalDefinitionParser
implements MuleChildDefinitionParser {
    protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.setRegistry(parserContext.getRegistry());
        this.parseChild(element, parserContext, builder);
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setSingleton(this.isSingleton());
        super.doParse(element, parserContext, builder);
    }

    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        super.postProcess(context, assembler, element);
        String propertyName = this.getPropertyName(element);
        if (null != propertyName) {
            if (!assembler.getBean().getBeanDefinition().isSingleton()) {
                assembler.insertBeanInTarget(propertyName);
            } else {
                assembler.getTarget().getPropertyValues().addPropertyValue(propertyName, (Object)new RuntimeBeanReference(element.getAttribute("name")));
            }
        }
    }

    public String getBeanName(Element e) {
        String name = SpringXMLUtils.getNameOrId(e);
        if (StringUtils.isBlank((String)name)) {
            String parentId = this.getParentBeanName(e);
            if (!parentId.startsWith(".")) {
                parentId = "." + parentId;
            }
            return AutoIdUtils.uniqueValue(parentId + ":" + e.getLocalName());
        }
        return name;
    }

    public abstract String getPropertyName(Element var1);
}

