/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.IOException;
import java.io.InputStream;
import org.mule.api.MuleContext;
import org.mule.api.registry.Registry;
import org.mule.config.ConfigResource;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleBeanDefinitionDocumentReader;
import org.mule.config.spring.MuleContextPostProcessor;
import org.mule.config.spring.SpringRegistry;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class MuleApplicationContext
extends AbstractXmlApplicationContext {
    public static final String LEGACY_BEAN_READER_CLASS = "org.mule.config.spring.MuleBeanDefinitionReader";
    private MuleContext muleContext;
    private Resource[] springResources;

    public MuleApplicationContext(MuleContext muleContext, Registry registry, ConfigResource[] configResources) {
        this(muleContext, registry, configResources, true);
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, ConfigResource[] configResources, ApplicationContext parent) {
        super(parent);
        this.setupParentSpringRegistry(registry);
        this.muleContext = muleContext;
        this.springResources = this.convert(configResources);
        this.refresh();
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, Resource[] configResources) {
        this(muleContext, registry, configResources, true);
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, ConfigResource[] configResources, boolean refresh) throws BeansException {
        this.muleContext = muleContext;
        this.setupParentSpringRegistry(registry);
        this.springResources = this.convert(configResources);
        if (refresh) {
            this.refresh();
        }
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, Resource[] springResources, ApplicationContext parent) throws IOException {
        super(parent);
        this.muleContext = muleContext;
        this.setupParentSpringRegistry(registry);
        this.springResources = springResources;
        this.refresh();
    }

    public MuleApplicationContext(MuleContext muleContext, Registry registry, Resource[] springResources, boolean refresh) throws BeansException {
        this.setupParentSpringRegistry(registry);
        this.muleContext = muleContext;
        this.springResources = springResources;
        if (refresh) {
            this.refresh();
        }
    }

    protected void setupParentSpringRegistry(Registry registry) {
        registry.setParent((Registry)new SpringRegistry((ConfigurableApplicationContext)this));
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new MuleContextPostProcessor(this.muleContext));
    }

    private Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray((InputStream)resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return configResources;
    }

    protected Resource[] getConfigResources() {
        return this.springResources;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader;
        if (ClassUtils.isClassOnPath((String)LEGACY_BEAN_READER_CLASS, ((Object)((Object)this)).getClass())) {
            try {
                beanDefinitionReader = (XmlBeanDefinitionReader)ClassUtils.instanciateClass((String)LEGACY_BEAN_READER_CLASS, (Object[])new Object[]{beanFactory, this.springResources});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        }
        beanDefinitionReader.setDocumentReaderClass(MuleBeanDefinitionDocumentReader.class);
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        beanDefinitionReader.loadBeanDefinitions(this.springResources);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory bf = super.createBeanFactory();
        if (this.getParent() != null) {
            AbstractBeanFactory beanFactory = (AbstractBeanFactory)this.getParent().getAutowireCapableBeanFactory();
            bf.copyConfigurationFrom((ConfigurableBeanFactory)beanFactory);
        }
        return bf;
    }
}

