/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.script;

import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.transformers.AbstractMessageAwareTransformer;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class ScriptTransformer
extends AbstractMessageAwareTransformer {
    protected final Scriptable scriptable = new Scriptable();

    public Object transform(UMOMessage message, String outputEncoding) throws TransformerException {
        Bindings bindings = this.getScriptEngine().createBindings();
        this.populateBindings(bindings, message);
        try {
            return this.scriptable.runScript(bindings);
        }
        catch (ScriptException e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected void populateBindings(Bindings namespace, UMOMessage message) {
        namespace.put("message", (Object)message);
        namespace.put("src", message.getPayload());
        namespace.put("transformerNamespace", (Object)namespace);
        namespace.put("log", (Object)this.logger);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        this.scriptable.initialise();
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptable.getScriptEngine();
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptable.setScriptEngine(scriptEngine);
    }

    public CompiledScript getCompiledScript() {
        return this.scriptable.getCompiledScript();
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.scriptable.setCompiledScript(compiledScript);
    }

    public String getScriptText() {
        return this.scriptable.getScriptText();
    }

    public void setScriptText(String scriptText) {
        this.scriptable.setScriptText(scriptText);
    }

    public String getScriptFile() {
        return this.scriptable.getScriptFile();
    }

    public void setScriptFile(String scriptFile) {
        this.scriptable.setScriptFile(scriptFile);
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptable.setScriptEngineName(scriptEngineName);
    }

    public String getScriptEngineName() {
        return this.scriptable.getScriptEngineName();
    }
}

