/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.script.CompiledScript;
import javax.script.Namespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.builders.QuickConfigurationBuilder;
import org.mule.config.i18n.Message;
import org.mule.umo.manager.UMOManager;
import org.mule.util.PropertiesUtils;

public class ScriptConfigurationBuilder
extends Scriptable
implements ConfigurationBuilder {
    public static final String SCRIPT_ENGINE_NAME_PROPERTY = "org.mule.script.engine";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOManager manager = null;
    protected QuickConfigurationBuilder builder = new QuickConfigurationBuilder(false);
    protected boolean initialised = false;

    public ScriptConfigurationBuilder() {
        this.manager = MuleManager.getInstance();
        String scriptName = System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY);
        if (scriptName == null) {
            throw new NullPointerException(new Message(187, (Object)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.setScriptEngineName(scriptName);
    }

    public ScriptConfigurationBuilder(String scriptEngineName) {
        this.manager = MuleManager.getInstance();
        this.setScriptEngineName(scriptEngineName);
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        try {
            ReaderResource[] readers = ReaderResource.parseResources((String)configResources);
            if (startupPropertiesFile != null) {
                return this.configure(readers, PropertiesUtils.loadProperties((String)startupPropertiesFile, this.getClass()));
            }
            return this.configure(readers, null);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        if (startupProperties != null) {
            ((MuleManager)MuleManager.getInstance()).addProperties((Map)startupProperties);
        }
        try {
            for (int i = 0; i < configResources.length; ++i) {
                ReaderResource configResource = configResources[i];
                this.setScriptFile(configResource.getDescription());
                this.initialise();
                Namespace ns = this.getScriptEngine().createNamespace();
                this.populateNamespace(ns);
                CompiledScript script = this.compileScript(configResource.getReader());
                script.eval(ns);
            }
            if (System.getProperty("org.mule..start.after.config", "true").equalsIgnoreCase("true") && !this.manager.isStarted()) {
                this.manager.start();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        return this.manager;
    }

    protected void populateNamespace(Namespace namespace) {
        namespace.put((Object)"manager", (Object)this.manager);
        namespace.put((Object)"builder", (Object)this.builder);
    }

    public boolean isConfigured() {
        return this.manager != null;
    }
}

