/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class BreakInstr
extends Instr {
    private final IRScope scopeToReturnTo;
    private Operand returnValue;

    public BreakInstr(Operand rv, IRScope s2) {
        super(Operation.BREAK);
        this.scopeToReturnTo = s2;
        this.returnValue = rv;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.returnValue};
    }

    public IRScope getScopeToReturnTo() {
        return this.scopeToReturnTo;
    }

    public Operand getReturnValue() {
        return this.returnValue;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new BreakInstr(this.returnValue.cloneForInlining(ii), this.scopeToReturnTo);
    }

    @Override
    public Instr cloneForInlinedScope(InlinerInfo ii) {
        if (ii.getInlineHostScope() == this.scopeToReturnTo) {
            Variable v = ii.getCallResultVariable();
            return v == null ? null : new CopyInstr(v, this.returnValue.cloneForInlining(ii));
        }
        return this.cloneForInlining(ii);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.returnValue + (this.scopeToReturnTo == null ? "" : ", " + this.scopeToReturnTo) + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.returnValue = this.returnValue.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BreakInstr(this);
    }
}

