/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jnr.constants.platform.Fcntl;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ThreadedRunnable;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.ResourceException;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.ShellLauncher;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.encoding.Transcoder;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.IOOptions;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.SelectBlob;
import org.jruby.util.io.Stream;

@JRubyClass(name={"IO"}, include={"Enumerable"})
public class RubyIO
extends RubyObject
implements IOEncodable {
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIO(runtime, klass);
        }
    };
    private static String vendor;
    private static String msgEINTR;
    private static final ByteList NIL_BYTELIST;
    private static final ByteList RECURSIVE_BYTELIST;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final Set<String> UNSUPPORTED_SPAWN_OPTIONS;
    private static final Set<String> ALL_SPAWN_OPTIONS;
    protected Transcoder readconv = null;
    protected boolean writeconvInitialized = false;
    protected Transcoder writeconv = null;
    protected OpenFile openFile;
    protected List<RubyThread> blockingThreads;
    protected Encoding enc;
    protected Encoding enc2;
    protected int ecflags;
    protected IRubyObject ecopts;
    protected int writeconvPreEcflags;
    protected IRubyObject writeconvPreEcopts = this.ecopts = this.getRuntime().getNil();
    protected IRubyObject writeconvAsciicompat = this.ecopts;
    protected boolean popenSpecial;
    protected boolean hasBom = false;

    public RubyIO(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public RubyIO(Ruby runtime, OutputStream outputStream) {
        this(runtime, outputStream, true);
    }

    public RubyIO(Ruby runtime, OutputStream outputStream, boolean autoclose2) {
        super(runtime, runtime.getIO());
        if (outputStream == null) {
            throw runtime.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime, new ChannelDescriptor(Channels.newChannel(outputStream)), autoclose2));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(66);
    }

    public RubyIO(Ruby runtime, InputStream inputStream) {
        super(runtime, runtime.getIO());
        if (inputStream == null) {
            throw runtime.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime, new ChannelDescriptor(Channels.newChannel(inputStream))));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(1);
    }

    public RubyIO(Ruby runtime, Channel channel) {
        super(runtime, runtime.getIO());
        if (channel == null) {
            throw runtime.newRuntimeError("Opening null channel");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime, new ChannelDescriptor(channel)));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
    }

    public RubyIO(Ruby runtime, ShellLauncher.POpenProcess process, IOOptions ioOptions) {
        this(runtime, runtime.getIO(), process, null, ioOptions);
    }

    @Deprecated
    public RubyIO(Ruby runtime, RubyClass cls, ShellLauncher.POpenProcess process, RubyHash options2, IOOptions ioOptions) {
        super(runtime, cls);
        ioOptions = this.updateIOOptionsFromOptions(runtime.getCurrentContext(), options2, ioOptions);
        this.openFile = new OpenFile();
        this.setupPopen(ioOptions.getModeFlags(), process);
    }

    public RubyIO(Ruby runtime, STDIO stdio) {
        super(runtime, runtime.getIO());
        this.openFile = new OpenFile();
        switch (stdio) {
            case IN: {
                ChannelDescriptor descriptor = new ChannelDescriptor(runtime.getIn(), RubyIO.newModeFlags(runtime, ModeFlags.RDONLY), FileDescriptor.in);
                runtime.putFilenoMap(0, descriptor.getFileno());
                Stream mainStream = ChannelStream.open(runtime, descriptor);
                this.openFile.setMainStream(mainStream);
                break;
            }
            case OUT: {
                ChannelDescriptor descriptor = new ChannelDescriptor((Channel)Channels.newChannel(runtime.getOut()), RubyIO.newModeFlags(runtime, ModeFlags.WRONLY | ModeFlags.APPEND), FileDescriptor.out);
                runtime.putFilenoMap(1, descriptor.getFileno());
                Stream mainStream = ChannelStream.open(runtime, descriptor);
                this.openFile.setMainStream(mainStream);
                this.openFile.getMainStream().setSync(true);
                break;
            }
            case ERR: {
                ChannelDescriptor descriptor = new ChannelDescriptor((Channel)Channels.newChannel(runtime.getErr()), RubyIO.newModeFlags(runtime, ModeFlags.WRONLY | ModeFlags.APPEND), FileDescriptor.err);
                runtime.putFilenoMap(2, descriptor.getFileno());
                Stream mainStream = ChannelStream.open(runtime, descriptor);
                this.openFile.setMainStream(mainStream);
                this.openFile.getMainStream().setSync(true);
            }
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.openFile.setAutoclose(false);
        this.openFile.setStdio(true);
    }

    public static RubyIO newIO(Ruby runtime, Channel channel) {
        return new RubyIO(runtime, channel);
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    protected OpenFile getOpenFileChecked() {
        this.openFile.checkClosed(this.getRuntime());
        return this.openFile;
    }

    @Override
    public int getNativeTypeIndex() {
        return 26;
    }

    public static RubyClass createIOClass(Ruby runtime) {
        RubyClass ioClass = runtime.defineClass("IO", runtime.getObject(), IO_ALLOCATOR);
        ioClass.index = 31;
        ioClass.setReifiedClass(RubyIO.class);
        ioClass.kindOf = new RubyModule.JavaClassKindOf(RubyIO.class);
        ioClass.includeModule(runtime.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.setConstant("SEEK_SET", runtime.newFixnum(0));
        ioClass.setConstant("SEEK_CUR", runtime.newFixnum(1));
        ioClass.setConstant("SEEK_END", runtime.newFixnum(2));
        if (runtime.is1_9()) {
            ioClass.defineModuleUnder("WaitReadable");
            ioClass.defineModuleUnder("WaitWritable");
        }
        return ioClass;
    }

    public OutputStream getOutStream() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().newOutputStream();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    public InputStream getInStream() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().newInputStream();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    public Channel getChannel() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().getChannel();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @Deprecated
    public Stream getHandler() throws BadDescriptorException {
        return this.getOpenFileChecked().getMainStreamSafe();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reopenPath(Ruby runtime, IRubyObject[] args2) {
        RubyString pathString = runtime.is1_9() ? RubyFile.get_path(runtime.getCurrentContext(), args2[0]) : args2[0].convertToString();
        pathString = StringSupport.checkEmbeddedNulls(runtime, pathString);
        try {
            IOOptions modes;
            if (args2.length > 1) {
                RubyString modeString = args2[1].convertToString();
                modes = RubyIO.newIOOptions(runtime, ((Object)modeString).toString());
                this.openFile.setMode(modes.getModeFlags().getOpenFileFlags());
            } else {
                modes = RubyIO.newIOOptions(runtime, "r");
            }
            String path2 = ((Object)pathString).toString();
            this.openFile.setPath(path2);
            if (this.openFile.getMainStream() == null) {
                this.openFile.setMainStream(ChannelStream.fopen(runtime, path2, modes.getModeFlags()));
                if (this.openFile.getPipeStream() == null) return;
                this.openFile.getPipeStream().fclose();
                this.openFile.setPipeStream(null);
                return;
            }
            this.openFile.getMainStreamSafe().freopen(runtime, path2, RubyIO.newIOOptions(runtime, this.openFile.getModeAsString(runtime)).getModeFlags());
            if (this.openFile.getPipeStream() == null) return;
        }
        catch (InvalidValueException e) {
            throw runtime.newErrnoEINVALError();
        }
        catch (PipeException pe) {
            throw new IllegalStateException("For compile compatibility only");
        }
        catch (IOException ex) {
            throw new IllegalStateException("For compile compatibility only");
        }
        catch (BadDescriptorException ex) {
            throw new IllegalStateException("For compile compatibility only");
        }
        catch (FileExistsException fee) {
            throw new IllegalStateException("For compile compatibility only");
        }
    }

    protected void reopenIO(Ruby runtime, RubyIO ios) {
        try {
            if (ios.openFile == this.openFile) {
                return;
            }
            OpenFile origFile = ios.getOpenFileChecked();
            OpenFile selfFile = this.getOpenFileChecked();
            long pos2 = 0L;
            Stream origStream = origFile.getMainStreamSafe();
            ChannelDescriptor origDescriptor = origStream.getDescriptor();
            boolean origIsSeekable = origDescriptor.isSeekable();
            if (origFile.isReadable() && origIsSeekable) {
                pos2 = origStream.fgetpos();
            }
            if (origFile.getPipeStream() != null) {
                origFile.getPipeStream().fflush();
            } else if (origFile.isWritable()) {
                origStream.fflush();
            }
            if (selfFile.isWritable()) {
                selfFile.getWriteStreamSafe().fflush();
            }
            selfFile.setMode(origFile.getMode());
            selfFile.setProcess(origFile.getProcess());
            selfFile.setLineNumber(origFile.getLineNumber());
            selfFile.setPath(origFile.getPath());
            selfFile.setFinalizer(origFile.getFinalizer());
            Stream selfStream = selfFile.getMainStreamSafe();
            ChannelDescriptor selfDescriptor = selfStream.getDescriptor();
            boolean selfIsSeekable = selfDescriptor.isSeekable();
            if (runtime.getFileno(selfDescriptor) >= 0 && runtime.getFileno(selfDescriptor) <= 2) {
                selfStream.clearerr();
                origDescriptor.dup2Into(selfDescriptor);
                selfStream.setModes(origStream.getModes());
            } else {
                Stream pipeFile = selfFile.getPipeStream();
                selfStream.fclose();
                selfFile.setPipeStream(null);
                if (pipeFile != null) {
                    selfFile.setMainStream(ChannelStream.fdopen(runtime, origDescriptor, origDescriptor.getOriginalModes()));
                    selfFile.setPipeStream(pipeFile);
                } else {
                    selfFile.setMainStream(ChannelStream.open(runtime, origDescriptor.dup2(selfDescriptor.getFileno())));
                    selfFile.getMainStreamSafe().setSync(selfFile.getMainStreamSafe().isSync());
                }
            }
            if (origFile.isReadable() && pos2 >= 0L) {
                if (selfIsSeekable) {
                    selfFile.seek(pos2, 0);
                }
                if (origIsSeekable) {
                    origFile.seek(pos2, 0);
                }
            }
            if (selfFile.getPipeStream() != null && selfDescriptor.getFileno() != selfFile.getPipeStream().getDescriptor().getFileno()) {
                int fd = selfFile.getPipeStream().getDescriptor().getFileno();
                if (origFile.getPipeStream() == null) {
                    selfFile.getPipeStream().fclose();
                    selfFile.setPipeStream(null);
                } else if (fd != origFile.getPipeStream().getDescriptor().getFileno()) {
                    selfFile.getPipeStream().fclose();
                    ChannelDescriptor newFD2 = origFile.getPipeStream().getDescriptor().dup2(fd);
                    selfFile.setPipeStream(ChannelStream.fdopen(runtime, newFD2, RubyIO.newIOOptions(runtime, "w").getModeFlags()));
                }
            }
            if ((selfFile.getMode() & 4) != 0) {
                selfFile.setBinmode();
            }
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newIOError("could not reopen: " + ex.getMessage());
        }
        catch (PipeException ex) {
            ex.printStackTrace();
            throw runtime.newIOError("could not reopen: " + ex.getMessage());
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime.getIO(), "to_io");
        if (!tmp.isNil()) {
            this.reopenIO(runtime, (RubyIO)tmp);
        } else {
            this.reopenPath(runtime, args2);
        }
        return this;
    }

    @Deprecated
    public static ModeFlags getIOModes(Ruby runtime, String modesString) {
        return RubyIO.newModeFlags(runtime, modesString);
    }

    @Deprecated
    public static int getIOModesIntFromString(Ruby runtime, String modesString) {
        try {
            return ModeFlags.getOFlagsFromString(modesString);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode");
        }
    }

    private ByteList separator(Ruby runtime) {
        return this.separator(runtime, runtime.getRecordSeparatorVar().get());
    }

    private ByteList separator(Ruby runtime, IRubyObject separatorValue) {
        ByteList separator;
        ByteList byteList = separator = separatorValue.isNil() ? null : separatorValue.convertToString().getByteList();
        if (separator != null) {
            if (separator.getRealSize() == 0) {
                return Stream.PARAGRAPH_DELIMETER;
            }
            if (runtime.is1_9() && separator.getEncoding() != this.getEnc()) {
                separator = Transcoder.strConvEncOpts(runtime.getCurrentContext(), separator, this.getEnc2(), this.getEnc(), 0, runtime.getNil());
            }
        }
        return separator;
    }

    private ByteList getSeparatorFromArgs(Ruby runtime, IRubyObject[] args2, int idx) {
        if (args2.length > idx && args2[idx] instanceof RubyFixnum) {
            return this.separator(runtime, runtime.getRecordSeparatorVar().get());
        }
        return this.separator(runtime, args2.length > idx ? args2[idx] : runtime.getRecordSeparatorVar().get());
    }

    private ByteList getSeparatorForGets(Ruby runtime, IRubyObject[] args2) {
        return this.getSeparatorFromArgs(runtime, args2, 0);
    }

    private IRubyObject getline(ThreadContext context, ByteList separator, ByteListCache cache) {
        return this.getline(context, separator, -1L, cache);
    }

    public IRubyObject getline(ThreadContext context, ByteList separator) {
        return this.getline(context, separator, -1L, null);
    }

    public IRubyObject getline(ThreadContext context, ByteList separator, long limit2) {
        return this.getline(context, separator, limit2, null);
    }

    private IRubyObject getline(ThreadContext context, ByteList separator, long limit2, ByteListCache cache) {
        return this.getlineInner(context, separator, limit2, cache);
    }

    private IRubyObject getlineEmptyString(Ruby runtime) {
        if (runtime.is1_9()) {
            return RubyString.newEmptyString(runtime, this.getReadEncoding());
        }
        return RubyString.newEmptyString(runtime);
    }

    private IRubyObject getlineAll(ThreadContext context, OpenFile myOpenFile) throws IOException, BadDescriptorException {
        Ruby runtime = context.runtime;
        RubyString str = (RubyString)this.readAll(context);
        if (str.getByteList().length() == 0) {
            return runtime.getNil();
        }
        this.incrementLineno(runtime, myOpenFile);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRubyObject getlineInner(ThreadContext context, ByteList separator, long limit2, ByteListCache cache) {
        Ruby runtime = context.runtime;
        try {
            int newline;
            boolean is19 = runtime.is1_9();
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            boolean isParagraph = separator == Stream.PARAGRAPH_DELIMETER;
            ByteList byteList = separator = isParagraph ? Stream.PARAGRAPH_SEPARATOR : separator;
            if (isParagraph) {
                this.swallow(10);
            }
            if (separator == null && limit2 < 0L) {
                return this.getlineAll(runtime.getCurrentContext(), myOpenFile);
            }
            if (limit2 == 0L) {
                return this.getlineEmptyString(runtime);
            }
            if (separator != null && separator.length() == 1 && limit2 < 0L) {
                if (!is19) return this.getlineFast(runtime, separator.get(0) & 0xFF, cache);
                if (!this.needsReadConversion() && this.getReadEncoding().isAsciiCompatible()) {
                    return this.getlineFast(runtime, separator.get(0) & 0xFF, cache);
                }
            }
            Stream readStream = myOpenFile.getMainStreamSafe();
            int c = -1;
            int n = -1;
            int n2 = newline = separator != null ? separator.get(separator.length() - 1) & 0xFF : -1;
            if (is19 && separator != null && separator.getEncoding() != this.getInputEncoding()) {
                separator = Transcoder.strConvEncOpts(runtime.getCurrentContext(), separator, separator.getEncoding(), this.getInputEncoding(), 0, context.nil);
                newline = separator.get(separator.length() - 1) & 0xFF;
            }
            ByteList buf = cache != null ? cache.allocate(0) : new ByteList(0);
            try {
                boolean update2 = false;
                boolean limitReached = false;
                if (is19) {
                    this.makeReadConversion(context);
                }
                while (true) {
                    block35: {
                        block38: {
                            block37: {
                                this.readCheck(readStream);
                                readStream.clearerr();
                                try {
                                    runtime.getCurrentContext().getThread().beforeBlockingCall();
                                    if (limit2 == -1L) {
                                        n = readStream.getline(buf, (byte)newline);
                                    } else {
                                        n = readStream.getline(buf, (byte)newline, limit2);
                                        if (buf.length() > 0 && StringSupport.isIncompleteChar(buf.get(buf.length() - 1))) {
                                            buf.append((byte)readStream.fgetc());
                                        }
                                        if ((limit2 -= (long)n) <= 0L) {
                                            limitReached = true;
                                            update2 = true;
                                            break block35;
                                        }
                                    }
                                    c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                                }
                                catch (EOFException e) {
                                    n = -1;
                                }
                                finally {
                                    runtime.getCurrentContext().getThread().afterBlockingCall();
                                }
                                if (n != 0) break block37;
                                this.waitReadable(readStream);
                                break block38;
                            }
                            if (n == -1) break block35;
                            update2 = true;
                        }
                        if (c != newline) continue;
                    }
                    if (n == -1 || limitReached || c == newline && separator != null && buf.length() >= separator.length() && 0 == ByteList.memcmp((byte[])buf.getUnsafeBytes(), (int)(buf.getBegin() + buf.getRealSize() - separator.length()), (byte[])separator.getUnsafeBytes(), (int)separator.getBegin(), (int)separator.getRealSize())) break;
                }
                if (is19 && this.readconv != null) {
                    buf = this.readconv.transcode(context, buf);
                }
                if (isParagraph && c != -1) {
                    this.swallow(10);
                }
                if (!update2) {
                    IRubyObject e = runtime.getNil();
                    return e;
                }
                this.incrementLineno(runtime, myOpenFile);
                ByteList newBuf = cache != null ? new ByteList(buf) : buf;
                RubyString str = RubyString.newString(runtime, newBuf);
                IRubyObject iRubyObject = this.ioEncStr(str);
                return iRubyObject;
            }
            finally {
                if (cache != null) {
                    cache.release(buf);
                }
            }
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @Override
    public Encoding getEnc() {
        return this.enc;
    }

    public Encoding getReadEncoding() {
        return this.enc != null ? this.enc : EncodingUtils.defaultExternalEncoding(this.getRuntime());
    }

    @Override
    public Encoding getEnc2() {
        return this.enc2;
    }

    public Encoding getInputEncoding() {
        return this.enc2 != null ? this.enc2 : this.getReadEncoding();
    }

    private RubyString makeString(Ruby runtime, ByteList buffer, boolean isCached) {
        ByteList newBuf;
        ByteList byteList = newBuf = isCached ? new ByteList(buffer) : buffer;
        if (runtime.is1_9()) {
            newBuf.setEncoding(this.getReadEncoding());
        }
        RubyString str = RubyString.newString(runtime, newBuf);
        str.setTaint(true);
        return str;
    }

    private void incrementLineno(Ruby runtime, OpenFile myOpenFile) {
        int lineno2 = myOpenFile.getLineNumber() + 1;
        myOpenFile.setLineNumber(lineno2);
        runtime.setCurrentLine(lineno2);
        RubyArgsFile.setCurrentLineNumber(runtime.getArgsFile(), lineno2);
    }

    protected boolean swallow(int term) throws IOException, BadDescriptorException {
        int c;
        Stream readStream = this.openFile.getMainStreamSafe();
        do {
            this.readCheck(readStream);
            try {
                c = readStream.fgetc();
            }
            catch (EOFException e) {
                c = -1;
            }
            if (c == term) continue;
            readStream.ungetc(c);
            return true;
        } while (c != -1);
        return false;
    }

    public static boolean restartSystemCall(Exception e) {
        return vendor.startsWith("Apple") && e.getMessage().equals(msgEINTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject getlineFast(Ruby runtime, int delim, ByteListCache cache) throws IOException, BadDescriptorException {
        Stream readStream = this.openFile.getMainStreamSafe();
        int c = -1;
        ByteList buf = cache != null ? cache.allocate(0) : new ByteList(0);
        try {
            boolean update2 = false;
            do {
                int n;
                this.readCheck(readStream);
                readStream.clearerr();
                try {
                    runtime.getCurrentContext().getThread().beforeBlockingCall();
                    n = readStream.getline(buf, (byte)delim);
                    c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                }
                catch (EOFException e) {
                    n = -1;
                }
                finally {
                    runtime.getCurrentContext().getThread().afterBlockingCall();
                }
                if (n == 0) {
                    this.waitReadable(readStream);
                    continue;
                }
                if (n == -1) break;
                update2 = true;
            } while (c != delim);
            if (!update2) {
                IRubyObject iRubyObject = runtime.getNil();
                return iRubyObject;
            }
            this.incrementLineno(runtime, this.openFile);
            RubyString rubyString = this.makeString(runtime, buf, cache != null);
            return rubyString;
        }
        finally {
            if (cache != null) {
                cache.release(buf);
            }
        }
    }

    @JRubyMethod(name={"new", "for_fd"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        if (block.isGiven()) {
            String className = klass.getName();
            context.runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, className + "::new() does not take block; use " + className + "::open() instead");
        }
        return klass.newInstance(context, args2, block);
    }

    private IRubyObject initializeCommon19(ThreadContext context, int fileno2, IRubyObject vmodeArg, IRubyObject opt) {
        Ruby runtime = context.runtime;
        int[] oflags_p = new int[]{ModeFlags.RDONLY};
        if (!(opt == null || opt.isNil() || opt instanceof RubyHash || opt.respondsTo("to_hash"))) {
            throw runtime.newArgumentError("last argument must be a hash!");
        }
        if (opt != null && !opt.isNil()) {
            opt = opt.convertToHash();
        }
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno(runtime.getFilenoExtMap(fileno2));
            if (descriptor == null) {
                throw runtime.newErrnoEBADFError();
            }
            descriptor.checkOpen();
            IRubyObject[] pm = new IRubyObject[]{runtime.newFixnum(0), vmodeArg};
            int[] fmode_p = new int[]{0};
            EncodingUtils.extractModeEncoding(context, this, pm, opt, oflags_p, fmode_p);
            oflags_p[0] = descriptor.getOriginalModes().getFlags();
            int ofmode = ModeFlags.getOpenFileFlagsFor(oflags_p[0]);
            if (pm[1] == null || pm[1].isNil()) {
                fmode_p[0] = ofmode;
            } else if ((~ofmode & fmode_p[0] & 3) != 0) {
                throw runtime.newErrnoEINVALError();
            }
            if (!opt.isNil() && ((RubyHash)opt).op_aref(context, runtime.newSymbol("autoclose")) == runtime.getFalse()) {
                this.setAutoclose(false);
            }
            this.MakeOpenFile();
            ModeFlags modes = ModeFlags.createModeFlags(oflags_p[0]);
            this.openFile.setMode(fmode_p[0]);
            this.openFile.setMainStream(this.fdopen(descriptor, modes));
            this.clearCodeConversion();
            if (this.hasBom) {
                EncodingUtils.ioSetEncodingByBOM(context, this);
            }
        }
        catch (BadDescriptorException ex) {
            throw context.runtime.newErrnoEBADFError();
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, Block unused2) {
        return this.initializeCommon19(context, RubyNumeric.fix2int(fileNumber), null, context.nil);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject second, Block unused2) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        IRubyObject vmode = null;
        IRubyObject options2 = null;
        IRubyObject hashTest = TypeConverter.checkHashType(context.runtime, second);
        if (hashTest instanceof RubyHash) {
            options2 = hashTest;
        } else {
            options2 = context.nil;
            vmode = second;
        }
        return this.initializeCommon19(context, fileno2, vmode, options2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject modeValue, IRubyObject options2, Block unused2) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        return this.initializeCommon19(context, fileno2, modeValue, options2);
    }

    protected IOOptions parseIOOptions(IRubyObject arg2) {
        Ruby runtime = this.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            return RubyIO.newIOOptions(runtime, (int)RubyFixnum.fix2long(arg2));
        }
        return RubyIO.newIOOptions(runtime, RubyIO.newModeFlags(runtime, arg2.convertToString().toString()));
    }

    protected IOOptions parseIOOptions19(IRubyObject arg2) {
        Ruby runtime = this.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            return RubyIO.newIOOptions(runtime, (int)RubyFixnum.fix2long(arg2));
        }
        String modeString = arg2.convertToString().toString();
        try {
            return new IOOptions(runtime, modeString);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("invalid access mode " + modeString);
        }
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime = this.getRuntime();
        int argCount = args2.length;
        int fileno2 = RubyNumeric.fix2int(args2[0]);
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno(runtime.getFilenoExtMap(fileno2));
            if (descriptor == null) {
                throw runtime.newErrnoEBADFError();
            }
            descriptor.checkOpen();
            IOOptions ioOptions = argCount == 2 ? (args2[1] instanceof RubyFixnum ? RubyIO.newIOOptions(runtime, RubyFixnum.fix2long(args2[1])) : RubyIO.newIOOptions(runtime, args2[1].convertToString().toString())) : RubyIO.newIOOptions(runtime, descriptor.getOriginalModes());
            this.MakeOpenFile();
            if (this.openFile.isOpen()) {
                this.openFile.cleanup(runtime, false);
            }
            this.openFile.setMode(ioOptions.getModeFlags().getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, ioOptions.getModeFlags()));
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        return this;
    }

    protected Stream fdopen(ChannelDescriptor existingDescriptor, ModeFlags modes) {
        Ruby runtime = this.getRuntime();
        if (existingDescriptor == null) {
            throw runtime.newErrnoEBADFError();
        }
        try {
            return ChannelStream.fdopen(runtime, existingDescriptor, modes);
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject external_encoding(ThreadContext context) {
        EncodingService encodingService = context.runtime.getEncodingService();
        if (this.enc2 != null) {
            return encodingService.getEncoding(this.enc2);
        }
        if (this.openFile.isWritable()) {
            return this.enc == null ? context.runtime.getNil() : encodingService.getEncoding(this.enc);
        }
        return encodingService.getEncoding(this.getReadEncoding());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject internal_encoding(ThreadContext context) {
        if (this.enc2 == null) {
            return context.nil;
        }
        return context.runtime.getEncodingService().getEncoding(this.getReadEncoding());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingObj) {
        this.setEncoding(context, encodingObj, context.nil, context.nil);
        return context.nil;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding) {
        IRubyObject opt = TypeConverter.checkHashType(context.runtime, internalEncoding);
        if (!opt.isNil()) {
            this.setEncoding(context, encodingString, context.nil, opt);
        } else {
            this.setEncoding(context, encodingString, internalEncoding, context.nil);
        }
        return context.nil;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding, IRubyObject options2) {
        this.setEncoding(context, encodingString, internalEncoding, options2);
        return context.nil;
    }

    public void setEncoding(ThreadContext context, IRubyObject v1, IRubyObject v2, IRubyObject opt) {
        IOEncodable.ConvConfig holder = new IOEncodable.ConvConfig();
        int ecflags = this.ecflags;
        IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
        if (!v2.isNil()) {
            holder.enc2 = EncodingUtils.rbToEncoding(context, v1);
            IRubyObject tmp = v2.checkStringType19();
            if (!tmp.isNil()) {
                RubyString internalAsString = (RubyString)tmp;
                if (internalAsString.size() == 1 && internalAsString.asJavaString().equals("-")) {
                    holder.enc = holder.enc2;
                    holder.enc2 = null;
                } else {
                    holder.enc = EncodingUtils.rbToEncoding(context, internalAsString);
                }
                if (holder.enc == holder.enc2) {
                    holder.enc2 = null;
                }
            } else {
                holder.enc = EncodingUtils.rbToEncoding(context, v2);
                if (holder.enc == holder.enc2) {
                    holder.enc2 = null;
                }
            }
            EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            ecflags = EncodingUtils.econvPrepareOptions(context, opt, ecopts_p, ecflags);
        } else if (v1.isNil()) {
            EncodingUtils.ioExtIntToEncs(context, holder, null, null, 0);
            EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            ecopts_p[0] = context.nil;
        } else {
            IRubyObject tmp = v1.checkStringType19();
            if (!tmp.isNil() && EncodingUtils.encAsciicompat(EncodingUtils.encGet(context, tmp))) {
                EncodingUtils.parseModeEncoding(context, holder, tmp.asJavaString(), null);
                EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
                ecflags = EncodingUtils.econvPrepareOptions(context, opt, ecopts_p, ecflags);
            } else {
                EncodingUtils.ioExtIntToEncs(context, holder, EncodingUtils.rbToEncoding(context, v1), null, 0);
                EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            }
        }
        int[] fmode_p = new int[]{this.openFile.getMode()};
        EncodingUtils.validateEncodingBinmode(context, fmode_p, ecflags, holder);
        this.openFile.setMode(fmode_p[0]);
        this.enc = holder.enc;
        this.enc2 = holder.enc2;
        this.ecflags = ecflags;
        this.ecopts = ecopts_p[0];
        this.clearCodeConversion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass klass = (RubyClass)recv2;
        RubyIO io2 = (RubyIO)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, io2);
                return iRubyObject;
            }
            finally {
                try {
                    io2.getMetaClass().finvoke(context, (IRubyObject)io2, "close", IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                }
                catch (RaiseException re) {
                    RubyException rubyEx = re.getException();
                    if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                        runtime.getGlobalVariables().clear("$!");
                    }
                    throw re;
                }
            }
        }
        return io2;
    }

    @JRubyMethod(required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sysopen(IRubyObject recv2, IRubyObject[] args2, Block block) {
        StringSupport.checkStringSafety(recv2.getRuntime(), args2[0]);
        RubyString pathString = args2[0].convertToString();
        return RubyIO.sysopenCommon(recv2, args2, block, pathString);
    }

    @JRubyMethod(name={"sysopen"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject sysopen19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString path2 = RubyFile.get_path(context, args2[0]);
        StringSupport.checkStringSafety(context.runtime, path2);
        return RubyIO.sysopenCommon(recv2, args2, block, path2);
    }

    private static IRubyObject sysopenCommon(IRubyObject recv2, IRubyObject[] args2, Block block, IRubyObject pathString) {
        IOOptions modes;
        Ruby runtime = recv2.getRuntime();
        String path2 = pathString.toString();
        int perms = -1;
        if (args2.length > 1 && !args2[1].isNil()) {
            RubyString modeString = args2[1].convertToString();
            modes = RubyIO.newIOOptions(runtime, ((Object)modeString).toString());
        } else {
            modes = RubyIO.newIOOptions(runtime, "r");
        }
        if (args2.length > 2 && !args2[2].isNil()) {
            RubyInteger permsInt = args2.length >= 3 ? args2[2].convertToInteger() : null;
            perms = RubyNumeric.fix2int(permsInt);
        }
        int fileno2 = -1;
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open(runtime.getCurrentDirectory(), path2, modes.getModeFlags(), perms, runtime.getPosix(), runtime.getJRubyClassLoader());
            fileno2 = descriptor.getFileno();
        }
        catch (ResourceException resourceException) {
            throw resourceException.newRaiseException(runtime);
        }
        catch (FileNotFoundException ignored) {
            throw new IllegalStateException("For compile compatibility only");
        }
        catch (DirectoryAsFileException ignored) {
            throw new IllegalStateException("For compile compatibility only");
        }
        catch (FileExistsException ignored) {
            throw new IllegalStateException("For compile compatibility only");
        }
        catch (IOException ignored) {
            throw new IllegalStateException("For compile compatibility only");
        }
        return runtime.newFixnum(fileno2);
    }

    public boolean isAutoclose() {
        return this.openFile.isAutoclose();
    }

    public void setAutoclose(boolean autoclose2) {
        this.openFile.setAutoclose(autoclose2);
    }

    @JRubyMethod(name={"autoclose?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject autoclose(ThreadContext context) {
        return context.runtime.newBoolean(this.isAutoclose());
    }

    @JRubyMethod(name={"autoclose="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject autoclose_set(ThreadContext context, IRubyObject autoclose2) {
        this.setAutoclose(autoclose2.isTrue());
        return context.nil;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        if (this.isClosed()) {
            throw this.getRuntime().newIOError("closed stream");
        }
        this.setAscii8bitBinmode();
        return this;
    }

    @JRubyMethod(name={"binmode?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_binmode(ThreadContext context) {
        return RubyBoolean.newBoolean(context.runtime, this.openFile.isBinmode());
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        try {
            RubyString string2 = obj.asString();
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime);
            Stream writeStream = myOpenFile.getWriteStream();
            if (myOpenFile.isWriteBuffered()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "syswrite for buffered IO");
            }
            if (!writeStream.getDescriptor().isWritable()) {
                myOpenFile.checkClosed(runtime);
            }
            context.getThread().beforeBlockingCall();
            int read2 = writeStream.getDescriptor().write(string2.getByteList());
            if (read2 == -1) {
                // empty if block
            }
            RubyFixnum rubyFixnum = runtime.newFixnum(read2);
            return rubyFixnum;
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            if (e.getMessage().equals("Broken pipe")) {
                throw runtime.newErrnoEPIPEError();
            }
            if (e.getMessage().equals("Connection reset by peer")) {
                throw runtime.newErrnoEPIPEError();
            }
            throw runtime.newSystemCallError(e.getMessage());
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    @JRubyMethod(name={"write_nonblock"}, required=1)
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject obj) {
        return this.doWriteNonblock(context, obj, true);
    }

    public IRubyObject doWriteNonblock(ThreadContext context, IRubyObject obj, boolean useException) {
        Ruby runtime = context.runtime;
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            ChannelStream stream;
            int written;
            myOpenFile.checkWritable(context.runtime);
            RubyString str = obj.asString();
            if (str.getByteList().length() == 0) {
                return context.runtime.newFixnum(0);
            }
            if (myOpenFile.isWriteBuffered()) {
                context.runtime.getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "write_nonblock for buffered IO");
            }
            if ((written = (stream = (ChannelStream)myOpenFile.getWriteStream()).writenonblock(str.getByteList())) == 0) {
                if (useException) {
                    if (runtime.is1_9()) {
                        throw runtime.newErrnoEAGAINWritableError("");
                    }
                    throw runtime.newErrnoEWOULDBLOCKError();
                }
                return runtime.fastNewSymbol("wait_writable");
            }
            return context.runtime.newFixnum(written);
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw context.runtime.newErrnoEINVALError();
        }
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        RubyString str = obj.asString();
        if (str.getByteList().length() == 0) {
            return runtime.newFixnum(0);
        }
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime);
            context.getThread().beforeBlockingCall();
            int written = this.fwrite(str);
            if (written == -1) {
                // empty if block
            }
            if (!myOpenFile.isSync()) {
                myOpenFile.setWriteBuffered();
            }
            RubyFixnum rubyFixnum = runtime.newFixnum(written);
            return rubyFixnum;
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    private boolean waitWritable(Stream stream) {
        Channel ch = stream.getChannel();
        if (ch instanceof SelectableChannel) {
            this.getRuntime().getCurrentContext().getThread().select(ch, this, 4);
            return true;
        }
        return false;
    }

    private boolean waitReadable(Stream stream) {
        if (stream.readDataBuffered()) {
            return true;
        }
        Channel ch = stream.getChannel();
        if (ch instanceof SelectableChannel) {
            this.getRuntime().getCurrentContext().getThread().select(ch, this, 1);
            return true;
        }
        return false;
    }

    protected int fwrite(RubyString buffer) {
        int len;
        int n;
        int offset2 = 0;
        boolean eagain = false;
        Stream writeStream = this.openFile.getWriteStream();
        if (this.getRuntime().is1_9()) {
            buffer = (RubyString)this.doWriteConversion(this.getRuntime().getCurrentContext(), buffer);
        }
        if ((n = (len = buffer.size())) <= 0) {
            return n;
        }
        if (Platform.IS_WINDOWS && this.tty_p(this.getRuntime().getCurrentContext()).isTrue() && System.console() != null) {
            System.console().printf("%s", buffer.asJavaString());
            return len;
        }
        try {
            if (this.openFile.isSync()) {
                this.openFile.fflush(writeStream);
                while (offset2 < len) {
                    int l = n;
                    int r = writeStream.getDescriptor().write(buffer.getByteList(), offset2, l);
                    if (r == len) {
                        return len;
                    }
                    if (0 <= r) {
                        offset2 += r;
                        n -= r;
                        eagain = true;
                    }
                    if (eagain && this.waitWritable(writeStream)) {
                        this.openFile.checkClosed(this.getRuntime());
                        if (offset2 >= buffer.size()) {
                            return -1;
                        }
                        eagain = false;
                        continue;
                    }
                    return -1;
                }
            }
            return writeStream.fwrite(buffer.getByteList());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        this.callMethod(context, "write", anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            return runtime.newFixnum(runtime.getFileno(this.getOpenFileChecked().getMainStreamSafe().getDescriptor()));
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno(ThreadContext context) {
        return context.runtime.newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(ThreadContext context, IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(newLineNumber));
        return context.runtime.newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync(ThreadContext context) {
        try {
            return context.runtime.newBoolean(this.getOpenFileChecked().getMainStreamSafe().isSync());
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid(ThreadContext context) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return context.runtime.getNil();
        }
        long pid2 = myOpenFile.getPid();
        return context.runtime.newFixnum(pid2);
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos(ThreadContext context) {
        try {
            return context.runtime.newFixnum(this.getOpenFileChecked().getMainStreamSafe().fgetpos());
        }
        catch (InvalidValueException ex) {
            throw context.runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException bde) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw context.runtime.newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(ThreadContext context, IRubyObject newPosition) {
        long offset2 = RubyNumeric.num2long(newPosition);
        if (offset2 < 0L) {
            throw context.runtime.newSystemCallError("Negative seek offset");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.getMainStreamSafe().lseek(offset2, 0);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.runtime.newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.runtime.newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
        return context.runtime.newFixnum(offset2);
    }

    @JRubyMethod(name={"print"}, rest=true, reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        return context.runtime.is1_9() ? RubyIO.print19(context, this, args2) : RubyIO.print(context, this, args2);
    }

    public static IRubyObject print(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getLastLine()};
        }
        Ruby runtime = context.runtime;
        IRubyObject fs = runtime.getGlobalVariables().get("$,");
        IRubyObject rs = runtime.getGlobalVariables().get("$\\");
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (i2 > 0 && !fs.isNil()) {
                RubyIO.write(context, maybeIO, fs);
            }
            if (args2[i2].isNil()) {
                RubyIO.write(context, maybeIO, runtime.newString("nil"));
                continue;
            }
            RubyIO.write(context, maybeIO, args2[i2]);
        }
        if (args2.length > 0 && !rs.isNil()) {
            RubyIO.write(context, maybeIO, rs);
        }
        return context.nil;
    }

    public static IRubyObject print19(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getLastLine()};
        }
        Ruby runtime = context.runtime;
        IRubyObject fs = runtime.getGlobalVariables().get("$,");
        IRubyObject rs = runtime.getGlobalVariables().get("$\\");
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!fs.isNil() && i2 > 0) {
                RubyIO.write(context, maybeIO, fs);
            }
            RubyIO.write(context, maybeIO, args2[i2]);
        }
        if (args2.length > 0 && !rs.isNil()) {
            RubyIO.write(context, maybeIO, rs);
        }
        return context.nil;
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.callMethod(context, "write", RubyKernel.sprintf(context, this, args2));
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(ThreadContext context, IRubyObject object) {
        return RubyIO.putc(context, this, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject putc(ThreadContext context, IRubyObject maybeIO, IRubyObject object) {
        byte c = RubyNumeric.num2chr(object);
        if (maybeIO instanceof RubyIO) {
            RubyIO io2 = (RubyIO)maybeIO;
            try {
                OpenFile myOpenFile = io2.getOpenFileChecked();
                myOpenFile.checkWritable(context.runtime);
                Stream writeStream = myOpenFile.getWriteStream();
                writeStream.fputc(c);
                if (!myOpenFile.isSync()) return object;
                myOpenFile.fflush(writeStream);
                return object;
            }
            catch (IOException ex) {
                throw context.runtime.newIOErrorFromException(ex);
            }
            catch (BadDescriptorException e) {
                throw context.runtime.newErrnoEBADFError();
            }
            catch (InvalidValueException ex) {
                throw context.runtime.newErrnoEINVALError();
            }
        } else {
            maybeIO.callMethod(context, "write", RubyString.newStringNoCopy(context.runtime, new byte[]{c}));
        }
        return object;
    }

    public RubyFixnum seek(ThreadContext context, IRubyObject[] args2) {
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = 0;
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = RubyNumeric.fix2int(arg1.convertToInteger());
        return this.doSeek(context, offset2, whence);
    }

    private RubyFixnum doSeek(ThreadContext context, long offset2, int whence) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.seek(offset2, whence);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException ex) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.runtime.newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.runtime.newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"sysseek"}, required=1, optional=1)
    public RubyFixnum sysseek(ThreadContext context, IRubyObject[] args2) {
        long pos2;
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            if (myOpenFile.isReadable() && myOpenFile.isReadBuffered()) {
                throw context.runtime.newIOError("sysseek for buffered IO");
            }
            if (myOpenFile.isWritable() && myOpenFile.isWriteBuffered()) {
                context.runtime.getWarnings().warn(IRubyWarnings.ID.SYSSEEK_BUFFERED_IO, "sysseek for buffered IO");
            }
            pos2 = myOpenFile.getMainStreamSafe().getDescriptor().lseek(offset2, whence);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException ex) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.runtime.newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.runtime.newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
        return context.runtime.newFixnum(pos2);
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind(ThreadContext context) {
        OpenFile myOpenfile = this.getOpenFileChecked();
        try {
            myOpenfile.getMainStreamSafe().lseek(0L, 0);
            myOpenfile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.runtime.newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.runtime.newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
        myOpenfile.setLineNumber(0);
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime);
            Stream writeStream = myOpenFile.getWriteStream();
            writeStream.fflush();
            writeStream.sync();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject newSync) {
        try {
            this.getOpenFileChecked().setSync(newSync.isTrue());
            this.getOpenFileChecked().getMainStreamSafe().setSync(newSync.isTrue());
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().feof()) {
                return runtime.getTrue();
            }
            if (myOpenFile.getMainStreamSafe().readDataBuffered()) {
                return runtime.getFalse();
            }
            this.readCheck(myOpenFile.getMainStreamSafe());
            this.waitReadable(myOpenFile.getMainStreamSafe());
            myOpenFile.getMainStreamSafe().clearerr();
            int c = myOpenFile.getMainStreamSafe().fgetc();
            if (c != -1) {
                myOpenFile.getMainStreamSafe().ungetc(c);
                return runtime.getFalse();
            }
            myOpenFile.checkClosed(runtime);
            myOpenFile.getMainStreamSafe().clearerr();
            return runtime.getTrue();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p(ThreadContext context) {
        try {
            return context.runtime.newBoolean(context.runtime.getPosix().isatty(this.getOpenFileChecked().getMainStreamSafe().getDescriptor().getFileDescriptor()));
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        Ruby runtime = this.getRuntime();
        if (this == original) {
            return this;
        }
        RubyIO originalIO = (RubyIO)TypeConverter.convertToTypeWithCheck(original, runtime.getIO(), "to_io");
        OpenFile originalFile = originalIO.getOpenFileChecked();
        this.MakeOpenFile();
        OpenFile newFile = this.openFile;
        try {
            if (originalFile.getPipeStream() != null) {
                originalFile.getPipeStream().fflush();
                originalFile.getMainStreamSafe().lseek(0L, 1);
            } else if (originalFile.isWritable()) {
                originalFile.getMainStreamSafe().fflush();
            } else {
                originalFile.getMainStreamSafe().lseek(0L, 1);
            }
            newFile.setMode(originalFile.getMode());
            newFile.setProcess(originalFile.getProcess());
            newFile.setLineNumber(originalFile.getLineNumber());
            newFile.setPath(originalFile.getPath());
            newFile.setFinalizer(originalFile.getFinalizer());
            IOOptions modes = newFile.isReadable() ? (newFile.isWritable() ? (newFile.getPipeStream() != null ? RubyIO.newIOOptions(runtime, ModeFlags.RDONLY) : RubyIO.newIOOptions(runtime, ModeFlags.RDWR)) : RubyIO.newIOOptions(runtime, ModeFlags.RDONLY)) : (newFile.isWritable() ? RubyIO.newIOOptions(runtime, ModeFlags.WRONLY) : RubyIO.newIOOptions(runtime, originalFile.getMainStreamSafe().getModes()));
            ChannelDescriptor descriptor = originalFile.getMainStreamSafe().getDescriptor().dup();
            newFile.setMainStream(ChannelStream.fdopen(runtime, descriptor, modes.getModeFlags()));
            newFile.getMainStream().setSync(originalFile.getMainStreamSafe().isSync());
            if (originalFile.getMainStreamSafe().isBinmode()) {
                newFile.getMainStream().setBinmode();
            }
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        catch (PipeException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        catch (InvalidValueException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isClosed());
    }

    public boolean isClosed() {
        return this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        Ruby runtime = this.getRuntime();
        this.openFile.checkClosed(runtime);
        return this.ioClose(runtime);
    }

    protected IRubyObject ioClose(Ruby runtime) {
        if (this.openFile == null) {
            return runtime.getNil();
        }
        this.interruptBlockingThreads();
        this.openFile.cleanup(runtime, true);
        if (!this.popenSpecial && this.openFile.getProcess() != null) {
            RubyIO.obliterateProcess(this.openFile.getProcess());
            RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime, this.openFile.getProcess().exitValue(), this.openFile.getPid());
            runtime.getCurrentContext().setLastExitStatus(processResult);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write(ThreadContext context) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isReadable()) {
                throw context.runtime.newIOError("closing non-duplex IO for writing");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getPipeStream().fclose();
                myOpenFile.setPipeStream(null);
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFD);
            }
        }
        catch (BadDescriptorException bde) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isWritable()) {
                throw runtime.newIOError("closing non-duplex IO for reading");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getMainStreamSafe().fclose();
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFE);
                myOpenFile.setMainStream(myOpenFile.getPipeStream());
                myOpenFile.setPipeStream(null);
            }
        }
        catch (BadDescriptorException bde) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.getOpenFileChecked().getWriteStream().fflush();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets(ThreadContext context) {
        Ruby runtime = context.runtime;
        IRubyObject result2 = this.getline(context, this.separator(runtime, runtime.getRecordSeparatorVar().get()));
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets(ThreadContext context, IRubyObject separatorArg) {
        Ruby runtime = context.runtime;
        IRubyObject result2 = this.getline(context, this.separator(runtime, separatorArg));
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context) {
        Ruby runtime = context.runtime;
        IRubyObject result2 = this.getline(context, this.separator(runtime));
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context, IRubyObject arg2) {
        ByteList separator;
        Ruby runtime = context.runtime;
        long limit2 = -1L;
        IRubyObject test2 = TypeConverter.checkIntegerType(runtime, arg2, "to_int");
        if (test2 instanceof RubyInteger) {
            limit2 = RubyInteger.fix2long(test2);
            separator = this.separator(runtime);
        } else {
            separator = this.separator(runtime, arg2);
        }
        IRubyObject result2 = this.getline(context, separator, limit2);
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context, IRubyObject separator, IRubyObject limit_arg) {
        Ruby runtime = context.runtime;
        long limit2 = limit_arg.isNil() ? -1L : RubyNumeric.fix2long(TypeConverter.checkIntegerType(runtime, limit_arg, "to_int"));
        IRubyObject result2 = this.getline(context, this.separator(runtime, separator), limit2);
        if (!result2.isNil()) {
            context.setLastLine(result2);
        }
        return result2;
    }

    public boolean getBlocking() {
        try {
            return ((ChannelStream)this.openFile.getMainStreamSafe()).isBlocking();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd) {
        return this.ctl(context.runtime, cmd, null);
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd, IRubyObject arg2) {
        return this.ctl(context.runtime, cmd, arg2);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(ThreadContext context, IRubyObject[] args2) {
        IRubyObject cmd = args2[0];
        IRubyObject arg2 = args2.length == 2 ? args2[1] : context.runtime.getNil();
        return this.ctl(context.runtime, cmd, arg2);
    }

    public IRubyObject ctl(Ruby runtime, IRubyObject cmd, IRubyObject arg2) {
        block13: {
            long realCmd = cmd.convertToInteger().getLongValue();
            long nArg = 0L;
            if (realCmd == (long)Fcntl.F_GETFL.intValue()) {
                OpenFile myOpenFile = this.getOpenFileChecked();
                return runtime.newFixnum(myOpenFile.getMainStream().getModes().getFcntlFileFlags());
            }
            if (arg2 == null || arg2.isNil() || arg2 == runtime.getFalse()) {
                nArg = 0L;
            } else if (arg2 instanceof RubyFixnum) {
                nArg = RubyFixnum.fix2long(arg2);
            } else if (arg2 == runtime.getTrue()) {
                nArg = 1L;
            } else {
                throw runtime.newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            try {
                if (realCmd == 1L) break block13;
                if (realCmd == (long)Fcntl.F_SETFL.intValue() || realCmd == (long)Fcntl.F_SETFD.intValue()) {
                    if ((nArg & 1L) != 1L) {
                        boolean block = (nArg & (long)ModeFlags.NONBLOCK) != (long)ModeFlags.NONBLOCK;
                        myOpenFile.getMainStreamSafe().setBlocking(block);
                    }
                    break block13;
                }
                if (realCmd == (long)Fcntl.F_GETFL.intValue()) {
                    return myOpenFile.getMainStreamSafe().isBlocking() ? RubyFixnum.zero(runtime) : RubyFixnum.newFixnum(runtime, ModeFlags.NONBLOCK);
                }
                throw runtime.newNotImplementedError("JRuby only supports F_SETFL and F_GETFL with NONBLOCK for fcntl/ioctl");
            }
            catch (BadDescriptorException e) {
                throw runtime.newErrnoEBADFError();
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
        }
        return runtime.newFixnum(0);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context) {
        return RubyIO.puts0(context, this);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0) {
        return RubyIO.puts1(context, this, arg0);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.puts2(context, this, arg0, arg1);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.puts3(context, this, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.puts(context, this, args2);
    }

    public static IRubyObject puts0(ThreadContext context, IRubyObject maybeIO) {
        return RubyIO.writeSeparator(context, maybeIO);
    }

    public static IRubyObject puts1(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.putsSingle(context, runtime, maybeIO, arg0, separator);
        return context.nil;
    }

    public static IRubyObject puts2(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.putsSingle(context, runtime, maybeIO, arg0, separator);
        RubyIO.putsSingle(context, runtime, maybeIO, arg1, separator);
        return context.nil;
    }

    public static IRubyObject puts3(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.putsSingle(context, runtime, maybeIO, arg0, separator);
        RubyIO.putsSingle(context, runtime, maybeIO, arg1, separator);
        RubyIO.putsSingle(context, runtime, maybeIO, arg2, separator);
        return context.nil;
    }

    public static IRubyObject puts(ThreadContext context, IRubyObject maybeIO, IRubyObject ... args2) {
        if (args2.length == 0) {
            return RubyIO.writeSeparator(context, maybeIO);
        }
        return RubyIO.putsArray(context, maybeIO, args2);
    }

    private static IRubyObject writeSeparator(ThreadContext context, IRubyObject maybeIO) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.write(context, maybeIO, separator);
        return runtime.getNil();
    }

    private static IRubyObject putsArray(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubyIO.putsSingle(context, runtime, maybeIO, args2[i2], separator);
        }
        return runtime.getNil();
    }

    private static void putsSingle(ThreadContext context, Ruby runtime, IRubyObject maybeIO, IRubyObject arg2, RubyString separator) {
        ByteList line;
        if (arg2.isNil()) {
            line = RubyIO.getNilByteList(runtime);
        } else if (runtime.isInspecting(arg2)) {
            line = RECURSIVE_BYTELIST;
        } else {
            if (arg2 instanceof RubyArray) {
                RubyIO.inspectPuts(context, maybeIO, (RubyArray)arg2);
                return;
            }
            line = arg2.asString().getByteList();
        }
        RubyIO.write(context, maybeIO, line);
        if (line.length() == 0 || !line.endsWith(separator.getByteList())) {
            RubyIO.write(context, maybeIO, separator.getByteList());
        }
    }

    protected IRubyObject write(ThreadContext context, ByteList byteList) {
        return this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(context.runtime, byteList));
    }

    protected static IRubyObject write(ThreadContext context, IRubyObject maybeIO, ByteList byteList) {
        return maybeIO.callMethod(context, "write", RubyString.newStringShared(context.runtime, byteList));
    }

    public static IRubyObject write(ThreadContext context, IRubyObject maybeIO, IRubyObject str) {
        return maybeIO.callMethod(context, "write", str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject inspectPuts(ThreadContext context, IRubyObject maybeIO, RubyArray array) {
        try {
            context.runtime.registerInspecting(array);
            IRubyObject iRubyObject = RubyIO.putsArray(context, maybeIO, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            context.runtime.unregisterInspecting(array);
        }
    }

    @Override
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        if (!runtime.is1_9()) {
            return super.inspect();
        }
        if (this.openFile == null) {
            return super.inspect();
        }
        Stream stream = this.openFile.getMainStream();
        String className = this.getMetaClass().getRealClass().getName();
        String path2 = this.openFile.getPath();
        String status2 = "";
        if (path2 == null) {
            if (stream == null) {
                path2 = "";
                status2 = "(closed)";
            } else {
                path2 = "fd " + runtime.getFileno(stream.getDescriptor());
            }
        } else if (!this.openFile.isOpen()) {
            status2 = " (closed)";
        }
        String inspectStr = "#<" + className + ":" + path2 + status2 + ">";
        return runtime.newString(inspectStr);
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context) {
        IRubyObject line = this.gets(context);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject separator) {
        IRubyObject line = this.gets(context, separator);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"getc", "getbyte"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject getc() {
        int c = this.getcCommon();
        if (c == -1) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(c);
    }

    @JRubyMethod(name={"readchar"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject readchar19(ThreadContext context) {
        IRubyObject value2 = this.getc19(context);
        if (value2.isNil()) {
            throw context.runtime.newEOFError();
        }
        return value2;
    }

    @JRubyMethod(name={"getbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getbyte19(ThreadContext context) {
        return this.getc();
    }

    @JRubyMethod
    public IRubyObject readbyte(ThreadContext context) {
        int c = this.getcCommon();
        if (c == -1) {
            throw this.getRuntime().newEOFError();
        }
        return context.runtime.newFixnum(c);
    }

    private IRubyObject getcTranscoded(ThreadContext context, Stream stream) throws IOException, BadDescriptorException, InvalidValueException {
        int firstByte;
        this.SET_BINARY_MODE();
        this.makeReadConversion(context);
        Encoding read2 = this.getInputEncoding();
        int cr = 0;
        ByteList bytes2 = new ByteList();
        int r = 0;
        boolean done = false;
        while (!done && (firstByte = stream.fgetc()) != -1) {
            bytes2.append((byte)firstByte);
            r = StringSupport.preciseLength(read2, bytes2.getUnsafeBytes(), 0, bytes2.getRealSize());
            if (StringSupport.MBCLEN_NEEDMORE_P(r) || (bytes2 = this.readconv.econvStrConvert(context, bytes2, false)).length() == 0) continue;
        }
        if (StringSupport.MBCLEN_INVALID_P(r)) {
            r = StringSupport.length(read2, bytes2.getUnsafeBytes(), 0, bytes2.getRealSize());
            for (int i2 = bytes2.getRealSize(); i2 > r; --i2) {
                stream.ungetc(bytes2.get(i2));
            }
            bytes2.setRealSize(r);
            cr = 96;
        } else {
            cr = 64;
            if (StringSupport.MBCLEN_CHARFOUND_LEN(r) == 1 && read2.isAsciiCompatible() && Encoding.isAscii((int)bytes2.get(0))) {
                cr = 32;
            }
        }
        IRubyObject str = context.runtime.newString(bytes2);
        str = this.ioEncStr(str);
        ((RubyString)str).setCodeRange(cr);
        return str;
    }

    private IRubyObject ioEncStr(IRubyObject str) {
        str.setTaint(true);
        if (this.getRuntime().is1_9()) {
            ((EncodingCapable)((Object)str)).setEncoding(this.getReadEncoding());
        }
        return str;
    }

    private IRubyObject getcDirect(ThreadContext context, Stream stream, Encoding enc) throws InvalidValueException, BadDescriptorException, IOException {
        ByteList bytes2 = null;
        boolean shared = false;
        int cr = 0;
        int firstByte = stream.fgetc();
        if (firstByte == -1) {
            return context.runtime.getNil();
        }
        if (enc.isAsciiCompatible() && Encoding.isAscii((byte)((byte)firstByte))) {
            if (enc == ASCIIEncoding.INSTANCE) {
                bytes2 = RubyInteger.SINGLE_CHAR_BYTELISTS[firstByte];
                shared = true;
            } else {
                bytes2 = new ByteList(new byte[]{(byte)firstByte}, enc, false);
                shared = false;
                cr = 32;
            }
        } else {
            int len = enc.length((byte)firstByte);
            byte[] byteAry = new byte[len];
            byteAry[0] = (byte)firstByte;
            for (int i2 = 1; i2 < len; ++i2) {
                byte c = (byte)stream.fgetc();
                if (c == -1) {
                    bytes2 = new ByteList(byteAry, 0, i2 - 1, enc, false);
                    cr = 96;
                }
                byteAry[i2] = c;
            }
            if (bytes2 == null) {
                cr = 64;
                bytes2 = new ByteList(byteAry, enc, false);
            }
        }
        if (shared) {
            return RubyString.newStringShared(context.runtime, bytes2, cr);
        }
        return RubyString.newStringNoCopy(context.runtime, bytes2, enc, cr);
    }

    @JRubyMethod(name={"getc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getc19(ThreadContext context) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(context.runtime);
            myOpenFile.setReadBuffered();
            Stream stream = myOpenFile.getMainStreamSafe();
            this.readCheck(stream);
            this.waitReadable(stream);
            stream.clearerr();
            return this.ioGetc(context, stream);
        }
        catch (InvalidValueException ex) {
            throw context.runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw context.runtime.newEOFError();
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
    }

    private IRubyObject ioGetc(ThreadContext context, Stream stream) throws IOException, BadDescriptorException, InvalidValueException {
        if (this.needsReadConversion()) {
            return this.getcTranscoded(context, stream);
        }
        return this.getcDirect(context, stream, this.getInputEncoding());
    }

    private void SET_BINARY_MODE() {
        this.openFile.getMainStream().setBinmode();
    }

    public int getcCommon() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            Stream stream = myOpenFile.getMainStreamSafe();
            this.readCheck(stream);
            this.waitReadable(stream);
            stream.clearerr();
            return myOpenFile.getMainStreamSafe().fgetc();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
    }

    private void readCheck(Stream stream) {
        if (!stream.readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject ungetc(IRubyObject number) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            throw this.getRuntime().newIOError("unread stream");
        }
        this.ungetcCommon((int)number.convertToInteger().getLongValue());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"ungetc", "ungetbyte"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject ungetc19(IRubyObject character) {
        Ruby runtime = this.getRuntime();
        if (character.isNil()) {
            return runtime.getNil();
        }
        if (character instanceof RubyFixnum) {
            int c = (int)character.convertToInteger().getLongValue();
            this.ungetcCommon(c);
        } else if (character instanceof RubyString || character.respondsTo("to_str")) {
            RubyString str = (RubyString)character.callMethod(runtime.getCurrentContext(), "to_str");
            if (str.isEmpty()) {
                return runtime.getNil();
            }
            byte[] bytes2 = str.getBytes();
            for (int i2 = bytes2.length - 1; i2 >= 0; --i2) {
                byte c = bytes2[i2];
                this.ungetcCommon(c);
            }
        } else {
            throw runtime.newTypeError(character, runtime.getFixnum());
        }
        return runtime.getNil();
    }

    public void ungetcCommon(int ch) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().ungetc(ch) == -1 && ch != -1) {
                throw this.getRuntime().newIOError("ungetc failed");
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=1)
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args2) {
        return this.doReadNonblock(context, args2, true);
    }

    public IRubyObject doReadNonblock(ThreadContext context, IRubyObject[] args2, boolean useException) {
        RubyString str;
        IRubyObject value2 = this.getPartial(context, args2, true);
        if (value2.isNil()) {
            throw context.runtime.newEOFError();
        }
        if (value2 instanceof RubyString && (str = (RubyString)value2).isEmpty()) {
            Ruby ruby2 = context.runtime;
            if (useException) {
                if (ruby2.is1_9()) {
                    throw ruby2.newErrnoEAGAINReadableError("");
                }
                throw ruby2.newErrnoEAGAINError("");
            }
            return ruby2.fastNewSymbol("wait_readable");
        }
        return value2;
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2 = this.getPartial(context, args2, false);
        if (value2.isNil()) {
            throw context.runtime.newEOFError();
        }
        return value2;
    }

    private IRubyObject getPartial(ThreadContext context, IRubyObject[] args2, boolean isNonblocking) {
        Ruby runtime = context.runtime;
        int length2 = RubyNumeric.fix2int(args2[0]);
        if (length2 < 0) {
            throw runtime.newArgumentError("negative length " + length2 + " given");
        }
        IRubyObject stringArg = args2.length > 1 ? args2[1] : runtime.getNil();
        RubyString string2 = stringArg.isNil() ? RubyString.newEmptyString(runtime) : stringArg.convertToString();
        string2.empty();
        string2.setTaint(true);
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            if (length2 == 0) {
                return string2;
            }
            if (!(myOpenFile.getMainStreamSafe() instanceof ChannelStream)) {
                throw runtime.newNotImplementedError("readpartial only works with Nio based handlers");
            }
            ChannelStream stream = (ChannelStream)myOpenFile.getMainStreamSafe();
            ByteList buf = null;
            if (isNonblocking) {
                buf = stream.readnonblock(length2);
            } else {
                while (!(buf != null && buf.length() != 0 || stream.feof())) {
                    this.waitReadable(stream);
                    buf = stream.readpartial(length2);
                }
            }
            boolean empty = buf == null || buf.length() == 0;
            ByteList newBuf = empty ? ByteList.EMPTY_BYTELIST.dup() : buf;
            string2.view(newBuf);
            if (stream.feof() && empty) {
                return runtime.getNil();
            }
            return string2;
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException e) {
            throw runtime.newEOFError(e.getMessage());
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        int len = (int)RubyNumeric.num2long(args2[0]);
        if (len < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString str;
            if (args2.length == 1 || args2[1].isNil()) {
                if (len == 0) {
                    return RubyString.newEmptyString(this.getRuntime());
                }
                ByteList buffer = new ByteList(len);
                str = RubyString.newString(this.getRuntime(), buffer);
            } else {
                str = args2[1].convertToString();
                str.modify(len);
                if (len == 0) {
                    return str;
                }
                ByteList buffer = str.getByteList();
                buffer.length(0);
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStreamSafe().readDataBuffered()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
            this.waitReadable(myOpenFile.getMainStreamSafe());
            myOpenFile.checkClosed(this.getRuntime());
            int bytesRead = myOpenFile.getMainStreamSafe().getDescriptor().read(len, str.getByteList());
            if (bytesRead == -1 || bytesRead == 0 && len > 0) {
                throw this.getRuntime().newEOFError();
            }
            str.setTaint(true);
            return str;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            this.synthesizeSystemCallError(e);
            return null;
        }
    }

    private void synthesizeSystemCallError(IOException e) {
        String errorMessage = e.getMessage();
        if ("File not open".equals(errorMessage)) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        if ("An established connection was aborted by the software in your host machine".equals(errorMessage)) {
            throw this.getRuntime().newErrnoECONNABORTEDError();
        }
        if ("Connection reset by peer".equals(e.getMessage()) || "An existing connection was forcibly closed by the remote host".equals(e.getMessage())) {
            throw this.getRuntime().newErrnoECONNRESETError();
        }
        throw this.getRuntime().newSystemCallError(e.getMessage());
    }

    public IRubyObject read(IRubyObject[] args2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        switch (args2.length) {
            case 0: {
                return this.read(context);
            }
            case 1: {
                return this.read(context, args2[0]);
            }
            case 2: {
                return this.read(context, args2[0], args2[1]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 2);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        Ruby runtime = context.runtime;
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            return this.readAll(context);
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException ex) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0) {
        if (arg0.isNil()) {
            return this.read(context);
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        RubyString str = RubyString.newEmptyString(this.getRuntime());
        return this.readNotAll(context, myOpenFile, length2, str);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (arg0.isNil()) {
            try {
                myOpenFile.checkReadable(this.getRuntime());
                myOpenFile.setReadBuffered();
                if (arg1.isNil()) {
                    return this.readAll(context);
                }
                return this.readAll(arg1.convertToString());
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (EOFException ex) {
                throw this.getRuntime().newEOFError();
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw this.getRuntime().newErrnoEBADFError();
            }
        }
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        if (arg1.isNil()) {
            return this.readNotAll(context, myOpenFile, length2);
        }
        return this.readNotAll(context, myOpenFile, length2, arg1.convertToString());
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length2, RubyString str) {
        Ruby runtime = context.runtime;
        str.empty();
        if (runtime.is1_9() && length2 == 0) {
            return str;
        }
        try {
            ByteList newBuffer = this.readNotAllCommon(context, myOpenFile, length2);
            if (RubyIO.emptyBufferOrEOF(newBuffer, myOpenFile)) {
                return runtime.getNil();
            }
            str.setValue(newBuffer);
            str.clearCodeRange();
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime.newEOFError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length2) {
        Ruby runtime = context.runtime;
        if (runtime.is1_9() && length2 == 0) {
            return RubyString.newEmptyString(runtime);
        }
        try {
            ByteList newBuffer = this.readNotAllCommon(context, myOpenFile, length2);
            if (RubyIO.emptyBufferOrEOF(newBuffer, myOpenFile)) {
                return runtime.getNil();
            }
            RubyString str = RubyString.newString(runtime, newBuffer);
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime.newEOFError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
    }

    private ByteList readNotAllCommon(ThreadContext context, OpenFile myOpenFile, int length2) {
        Ruby runtime = context.runtime;
        try {
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().feof()) {
                return null;
            }
            this.readCheck(myOpenFile.getMainStreamSafe());
            ByteList newBuffer = this.fread(context.getThread(), length2);
            return newBuffer;
        }
        catch (EOFException ex) {
            throw runtime.newEOFError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
    }

    protected static boolean emptyBufferOrEOF(ByteList buffer, OpenFile myOpenFile) throws BadDescriptorException, IOException {
        if (buffer == null) {
            return true;
        }
        if (buffer.length() == 0) {
            if (myOpenFile.getMainStreamSafe() == null) {
                return true;
            }
            if (myOpenFile.getMainStreamSafe().feof()) {
                return true;
            }
        }
        return false;
    }

    protected RubyString readAll(RubyString str) throws BadDescriptorException, EOFException, IOException {
        Ruby runtime = this.getRuntime();
        ByteList buf = this.readAllCommon(runtime);
        if (buf == null) {
            str.empty();
        } else {
            str.setValue(buf);
        }
        str.setTaint(true);
        return str;
    }

    protected IRubyObject readAll(ThreadContext context) throws BadDescriptorException, EOFException, IOException {
        Ruby runtime = this.getRuntime();
        if (runtime.is1_9() && this.needsReadConversion()) {
            this.openFile.setBinmode();
            this.makeReadConversion(context);
            ByteList buf = this.readAllCommon(runtime);
            if (this.readconv != null) {
                buf = this.readconv.transcode(runtime.getCurrentContext(), buf);
            }
            this.clearReadConversion();
            return this.ioEncStr(runtime.newString(buf));
        }
        ByteList buf = this.readAllCommon(runtime);
        RubyString str = buf == null ? RubyString.newEmptyString(runtime) : this.makeString(runtime, buf, false);
        str.setTaint(true);
        return str;
    }

    protected ByteList readAllCommon(Ruby runtime) throws BadDescriptorException, EOFException, IOException {
        ByteList buf;
        block8: {
            buf = null;
            ChannelDescriptor descriptor = this.openFile.getMainStreamSafe().getDescriptor();
            try {
                if (descriptor.isSeekable() && descriptor.getChannel() instanceof FileChannel) {
                    buf = this.openFile.getMainStreamSafe().readall();
                    break block8;
                }
                RubyThread thread2 = runtime.getCurrentContext().getThread();
                try {
                    while (true) {
                        Stream stream = this.openFile.getMainStreamSafe();
                        this.readCheck(stream);
                        this.openFile.checkReadable(runtime);
                        ByteList read2 = this.fread(thread2, 4096);
                        if (read2.length() != 0) {
                            if (buf == null) {
                                buf = read2;
                                continue;
                            }
                            buf.append(read2);
                            continue;
                        }
                        break;
                    }
                }
                catch (InvalidValueException ex) {
                    throw runtime.newErrnoEINVALError();
                }
            }
            catch (NonReadableChannelException ex) {
                throw runtime.newIOError("not opened for reading");
            }
        }
        return buf;
    }

    private ByteList fread(RubyThread thread2, int length2) throws IOException, BadDescriptorException {
        Stream stream = this.openFile.getMainStreamSafe();
        int rest2 = length2;
        this.waitReadable(stream);
        ByteList buf = this.blockingFRead(stream, thread2, length2);
        if (buf != null) {
            rest2 -= buf.length();
        }
        while (rest2 > 0) {
            this.waitReadable(stream);
            this.openFile.checkClosed(this.getRuntime());
            stream.clearerr();
            ByteList newBuffer = this.blockingFRead(stream, thread2, rest2);
            if (newBuffer == null) break;
            int len = newBuffer.length();
            if (len == 0) continue;
            if (buf == null) {
                buf = newBuffer;
            } else {
                buf.append(newBuffer);
            }
            rest2 -= len;
        }
        if (buf == null) {
            return ByteList.EMPTY_BYTELIST.dup();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteList blockingFRead(Stream stream, RubyThread thread2, int length2) throws IOException, BadDescriptorException {
        try {
            thread2.beforeBlockingCall();
            ByteList byteList = stream.fread(length2);
            return byteList;
        }
        finally {
            thread2.afterBlockingCall();
        }
    }

    @JRubyMethod(name={"readchar"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        this.openFile.checkClosed(context.runtime);
        try {
            return context.runtime.newFileStat(this.getOpenFileChecked().getMainStreamSafe().getDescriptor().getFileDescriptor());
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    public IRubyObject each_byteInternal(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            while (true) {
                myOpenFile.checkReadable(runtime);
                myOpenFile.setReadBuffered();
                this.waitReadable(myOpenFile.getMainStream());
                int c = myOpenFile.getMainStreamSafe().fgetc();
                if (c == -1) break;
                assert (c < 256);
                block.yield(context, this.getRuntime().newFixnum(c));
            }
            return this;
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod
    public IRubyObject each_byte(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byteInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
    }

    @JRubyMethod(name={"bytes"})
    public IRubyObject bytes(ThreadContext context) {
        return RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines(ThreadContext context, Block block) {
        return RubyEnumerator.enumeratorize(context.runtime, this, "each_line");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lines19(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_line");
        }
        return this.each_lineInternal(context, NULL_ARRAY, block);
    }

    public IRubyObject each_charInternal(ThreadContext context, Block block) {
        IRubyObject ch;
        Ruby runtime = context.runtime;
        while (!(ch = this.getc()).isNil()) {
            byte c = (byte)RubyNumeric.fix2int(ch);
            int n = runtime.getKCode().getEncoding().length(c);
            RubyString str = runtime.newString();
            if (runtime.is1_9()) {
                str.setEncoding(this.getReadEncoding());
            }
            str.setTaint(true);
            str.cat(c);
            while (--n > 0) {
                ch = this.getc();
                if (ch.isNil()) {
                    block.yield(context, str);
                    return this;
                }
                c = (byte)RubyNumeric.fix2int(ch);
                str.cat(c);
            }
            block.yield(context, str);
        }
        return this;
    }

    public IRubyObject each_charInternal19(ThreadContext context, Block block) {
        IRubyObject ch;
        while (!(ch = this.getc19(context)).isNil()) {
            block.yield(context, ch);
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject each_char(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
    }

    @JRubyMethod(name={"each_char"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_char19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal19(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject chars(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "chars");
    }

    @JRubyMethod(name={"chars"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chars19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal19(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "chars");
    }

    @JRubyMethod
    public IRubyObject codepoints(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "codepoints");
    }

    @JRubyMethod
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "each_codepoint");
    }

    private IRubyObject eachCodePointCommon(ThreadContext context, Block block, String methodName) {
        IRubyObject ch;
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, methodName);
        }
        while (!(ch = this.getc()).isNil()) {
            block.yield(context, ch);
        }
        return this;
    }

    public RubyIO each_lineInternal(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        ByteList separator = this.getSeparatorForGets(runtime, args2);
        ByteListCache cache = new ByteListCache();
        IRubyObject line = this.getline(context, separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getline(context, separator, cache);
        }
        return this;
    }

    @JRubyMethod(optional=1)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_lineInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", args2);
    }

    @JRubyMethod(optional=1)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_lineInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", args2);
    }

    @JRubyMethod(name={"readlines"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray readlines(ThreadContext context, IRubyObject[] args2) {
        return this.readlinesCommon(context, args2);
    }

    @JRubyMethod(name={"readlines"}, optional=2, compat=CompatVersion.RUBY1_9)
    public RubyArray readlines19(ThreadContext context, IRubyObject[] args2) {
        return this.readlinesCommon(context, args2);
    }

    private RubyArray readlinesCommon(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line;
        Ruby runtime = context.runtime;
        long limit2 = this.getLimitFromArgs(args2);
        ByteList separator = this.getSeparatorFromArgs(runtime, args2, 0);
        RubyArray result2 = runtime.newArray();
        while (!(line = this.getline(context, separator, limit2, null)).isNil()) {
            result2.append(line);
        }
        return result2;
    }

    private long getLimitFromArgs(IRubyObject[] args2) {
        long limit2 = -1L;
        if (args2.length > 1) {
            limit2 = RubyNumeric.num2long(args2[1]);
        } else if (args2.length > 0 && args2[0] instanceof RubyFixnum) {
            limit2 = RubyNumeric.num2long(args2[0]);
        }
        return limit2;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        try {
            return "RubyIO(" + this.openFile.getMode() + ", " + this.getRuntime().getFileno(this.openFile.getMainStreamSafe().getDescriptor()) + ")";
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject foreachInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyString filename2 = args2[0].convertToString();
        RubyIO io2 = RubyIO.newFile(context, runtime.getFile(), filename2);
        ByteListCache cache = new ByteListCache();
        if (!io2.isNil()) {
            try {
                ByteList separator = io2.getSeparatorFromArgs(runtime, args2, 1);
                IRubyObject str = io2.getline(context, separator, cache);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io2.getline(context, separator, cache);
                }
            }
            finally {
                io2.close();
            }
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject foreachInternal19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject opt = ArgsUtil.getOptionsArg(context.runtime, args2);
        IRubyObject io2 = RubyIO.openKeyArgs(context, recv2, args2, opt);
        if (io2.isNil()) {
            return io2;
        }
        IRubyObject[] methodArguments = RubyIO.processReadlinesMethodArguments(args2);
        ByteListCache cache = new ByteListCache();
        if (!io2.isNil()) {
            try {
                long limit2 = ((RubyIO)io2).getLimitFromArgs(methodArguments);
                ByteList separator = ((RubyIO)io2).getSeparatorFromArgs(runtime, methodArguments, 0);
                IRubyObject str = ((RubyIO)io2).getline(context, separator, limit2, cache);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = ((RubyIO)io2).getline(context, separator, limit2, cache);
                }
            }
            finally {
                ((RubyIO)io2).close();
                runtime.getGlobalVariables().clear("$_");
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "foreach", args2);
        }
        return RubyIO.foreachInternal(context, recv2, args2, block);
    }

    @JRubyMethod(name={"foreach"}, required=1, optional=3, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "foreach", args2);
        }
        return RubyIO.foreachInternal19(context, recv2, args2, block);
    }

    public static RubyIO convertToIO(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyIO) {
            return (RubyIO)obj;
        }
        return (RubyIO)TypeConverter.convertToType(obj, context.runtime.getIO(), "to_io");
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select_static(context, context.runtime, args2);
    }

    public static IRubyObject select_static(ThreadContext context, Ruby runtime, IRubyObject[] args2) {
        return new SelectBlob().goForIt(context, runtime, args2);
    }

    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyIO.readStatic(context, recv2, args2[0]);
            }
            case 2: {
                return RubyIO.readStatic(context, recv2, args2[0], args2[1]);
            }
            case 3: {
                return RubyIO.readStatic(context, recv2, args2[0], args2[1], args2[2]);
            }
            case 0: {
                throw context.runtime.newArgumentError(0, 1);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 3);
    }

    private static RubyIO newFile(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        return (RubyIO)RubyKernel.open(context, recv2, args2, Block.NULL_BLOCK);
    }

    public static void failIfDirectory(Ruby runtime, RubyString pathStr) {
        if (RubyFileTest.directory_p(runtime, (IRubyObject)pathStr).isTrue()) {
            if (Platform.IS_WINDOWS) {
                throw runtime.newErrnoEACCESError(pathStr.asJavaString());
            }
            throw runtime.newErrnoEISDirError(pathStr.asJavaString());
        }
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block unusedBlock) {
        return RubyIO.readStatic(context, recv2, path2);
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        return RubyIO.readStatic(context, recv2, path2, length2);
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2) {
        return RubyIO.readStatic(context, recv2, path2, length2, offset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        StringSupport.checkStringSafety(context.runtime, path2);
        RubyString pathStr = path2.convertToString();
        Ruby runtime = context.runtime;
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            IRubyObject iRubyObject = file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        StringSupport.checkStringSafety(context.runtime, path2);
        RubyString pathStr = path2.convertToString();
        Ruby runtime = context.runtime;
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            IRubyObject iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2) {
        StringSupport.checkStringSafety(context.runtime, path2);
        RubyString pathStr = path2.convertToString();
        Ruby runtime = context.runtime;
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject read19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2, IRubyObject options2) {
        RubyIO file2 = (RubyIO)RubyIO.openKeyArgs(context, recv2, new IRubyObject[]{path2, length2, offset2}, options2);
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    private static IRubyObject openKeyArgs(ThreadContext context, IRubyObject recv2, IRubyObject[] argv, IRubyObject opt) {
        Ruby runtime = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, argv[0]));
        RubyIO.failIfDirectory(runtime, path2);
        if (opt.isNil()) {
            return RubyIO.ioOpen(context, path2, runtime.newFixnum(ModeFlags.RDONLY), runtime.newFixnum(438), opt);
        }
        IRubyObject v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("open_args"));
        if (!v.isNil()) {
            v = v.convertToArray();
            int n = ((RubyArray)v).size() + 1;
            RubyArray args2 = runtime.newArray(n);
            args2.push_m19(new IRubyObject[]{path2});
            args2.concat19(v);
            return RubyKernel.open19(context, recv2, args2.toJavaArray(), Block.NULL_BLOCK);
        }
        return RubyIO.ioOpen(context, path2, context.nil, context.nil, opt);
    }

    public static IRubyObject ioOpen(ThreadContext context, IRubyObject filename2, IRubyObject vmode, IRubyObject vperm, IRubyObject opt) {
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        IRubyObject[] pm = new IRubyObject[]{vperm, vmode};
        if (filename2 instanceof RubyString && ((RubyString)filename2).isEmpty()) {
            throw context.getRuntime().newErrnoENOENTError();
        }
        RubyFile file2 = (RubyFile)context.runtime.getFile().allocate();
        EncodingUtils.extractModeEncoding(context, file2, pm, opt, oflags_p, fmode_p);
        int perm = pm[0] == null || pm[0].isNil() ? 438 : RubyNumeric.num2int(pm[0]);
        IRubyObject cmd = RubyIO.checkPipeCommand(context, filename2);
        if (!cmd.isNil()) {
            return (RubyIO)RubyKernel.open19(context, context.runtime.getIO(), new IRubyObject[]{filename2, vmode, opt}, Block.NULL_BLOCK);
        }
        return file2.fileOpenGeneric(context, filename2, oflags_p[0], fmode_p[0], file2, perm);
    }

    public static IRubyObject checkPipeCommand(ThreadContext context, IRubyObject filenameOrCommand) {
        RubyString filenameStr = filenameOrCommand.convertToString();
        ByteList filenameByteList = filenameStr.getByteList();
        if (EncodingUtils.encAscget(filenameByteList.getUnsafeBytes(), filenameByteList.getBegin(), filenameByteList.getBegin() + filenameByteList.getRealSize(), null, filenameByteList.getEncoding()) == 124) {
            return filenameStr.makeShared19(context.runtime, 0, 1).infectBy(filenameOrCommand);
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject write19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject str, IRubyObject offset2, RubyHash options2) {
        Ruby runtime = context.runtime;
        RubyString pathStr = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, path2));
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = null;
        long mode2 = ModeFlags.CREAT;
        if (options2 == null || options2 != null && options2.isEmpty()) {
            mode2 = offset2.isNil() ? (mode2 |= (long)ModeFlags.WRONLY) : (mode2 |= (long)ModeFlags.RDWR);
            file2 = (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)RubyFixnum.newFixnum(runtime, mode2));
        } else {
            file2 = !options2.containsKey(runtime.newSymbol("mode")) ? (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)RubyFixnum.newFixnum(runtime, mode2 |= (long)ModeFlags.WRONLY), (IRubyObject)options2) : (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)options2);
        }
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = file2.write(context, str);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, required=1, optional=2, compat=CompatVersion.RUBY1_9)
    public static IRubyObject binread(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject nil = runtime.getNil();
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, args2[0]));
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        if (args2.length > 2) {
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 1) {
            length2 = args2[1];
        }
        RubyIO file2 = (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", (IRubyObject)path2, (IRubyObject)runtime.newString("rb:ASCII-8BIT"));
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    @JRubyMethod(name={"read"}, meta=true, required=1, optional=3, compat=CompatVersion.RUBY1_9)
    public static IRubyObject read19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime = context.runtime;
        IRubyObject nil = runtime.getNil();
        IRubyObject path2 = args2[0];
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        IRubyObject options2 = nil;
        if (args2.length > 3) {
            if (!(args2[3] instanceof RubyHash)) {
                throw runtime.newTypeError("Must be a hash");
            }
            options2 = (RubyHash)args2[3];
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 2) {
            if (args2[2] instanceof RubyHash) {
                options2 = (RubyHash)args2[2];
            } else {
                offset2 = args2[2];
            }
            length2 = args2[1];
        } else if (args2.length > 1) {
            if (args2[1] instanceof RubyHash) {
                options2 = (RubyHash)args2[1];
            } else {
                length2 = args2[1];
            }
        }
        if (options2 == null) {
            options2 = RubyHash.newHash(runtime);
        }
        return RubyIO.read19(context, recv2, path2, length2, offset2, options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, required=2, optional=2, compat=CompatVersion.RUBY1_9)
    public static IRubyObject binwrite(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject path2 = args2[0];
        IRubyObject str = args2[1];
        RubyInteger offset2 = null;
        RubyHash options2 = null;
        Ruby runtime = context.runtime;
        if (args2.length > 2) {
            if (args2[2] instanceof RubyHash) {
                options2 = args2[2].convertToHash();
            } else {
                offset2 = args2[2].convertToInteger();
            }
        }
        if (args2.length > 3) {
            options2 = args2[3].convertToHash();
        }
        RubyIO file2 = null;
        long mode2 = ModeFlags.CREAT | ModeFlags.BINARY;
        if (options2 == null || options2 != null && options2.isEmpty()) {
            mode2 = offset2 == null ? (mode2 |= (long)ModeFlags.WRONLY) : (mode2 |= (long)ModeFlags.RDWR);
            file2 = (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)RubyFixnum.newFixnum(runtime, mode2));
        } else {
            file2 = !options2.containsKey(runtime.newSymbol("mode")) ? (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)RubyFixnum.newFixnum(runtime, mode2 |= (long)ModeFlags.WRONLY), (IRubyObject)options2) : (RubyIO)Helpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)options2);
        }
        try {
            if (offset2 != null) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = file2.write(context, str);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    @JRubyMethod(name={"write"}, meta=true, required=2, optional=2, compat=CompatVersion.RUBY1_9)
    public static IRubyObject writeStatic(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        IRubyObject nil = context.nil;
        IRubyObject path2 = args2[0];
        IRubyObject str = args2[1];
        IRubyObject offset2 = nil;
        RubyHash options2 = null;
        if (args2.length > 3) {
            if (!(args2[3] instanceof RubyHash)) {
                throw context.runtime.newTypeError("Must be a hash");
            }
            options2 = (RubyHash)args2[3];
            offset2 = args2[2];
        } else if (args2.length > 2) {
            if (args2[2] instanceof RubyHash) {
                options2 = (RubyHash)args2[2];
            } else {
                offset2 = args2[2];
            }
        }
        return RubyIO.write19(context, recv2, path2, str, offset2, options2);
    }

    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        IRubyObject[] iRubyObjectArray;
        int count2 = args2.length;
        IRubyObject[] fileArguments = new IRubyObject[]{args2[0].convertToString()};
        if (count2 >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args2[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        return RubyIO.readlinesCommon(context, recv2, fileArguments, separatorArguments);
    }

    @JRubyMethod(name={"readlines"}, required=1, optional=3, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject readlines19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        int argc = args2.length;
        IRubyObject opt = ArgsUtil.getOptionsArg(context.runtime, args2);
        IRubyObject io2 = RubyIO.openKeyArgs(context, recv2, args2, opt);
        if (io2.isNil()) {
            return io2;
        }
        IRubyObject[] methodArguments = RubyIO.processReadlinesMethodArguments(args2);
        return RubyIO.readlinesCommon19(context, (RubyIO)io2, methodArguments);
    }

    private static IRubyObject[] processReadlinesMethodArguments(IRubyObject[] args2) {
        int count2 = args2.length;
        IRubyObject[] methodArguments = IRubyObject.NULL_ARRAY;
        if (count2 >= 3 && (args2[2] instanceof RubyFixnum || args2[2].respondsTo("to_int"))) {
            methodArguments = new IRubyObject[]{args2[1], args2[2]};
        } else if (count2 >= 2 && (args2[1] instanceof RubyFixnum || args2[1].respondsTo("to_int"))) {
            methodArguments = new IRubyObject[]{args2[1]};
        } else if (count2 >= 2 && !(args2[1] instanceof RubyHash)) {
            methodArguments = new IRubyObject[]{args2[1]};
        }
        return methodArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyArray readlinesCommon(ThreadContext context, IRubyObject recv2, IRubyObject[] openFileArguments, IRubyObject[] methodArguments) {
        RubyIO file2 = (RubyIO)RubyKernel.open(context, recv2, openFileArguments, Block.NULL_BLOCK);
        try {
            RubyArray rubyArray = (RubyArray)file2.callMethod("readlines", methodArguments);
            return rubyArray;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyArray readlinesCommon19(ThreadContext context, RubyIO file2, IRubyObject[] newArguments) {
        try {
            RubyArray rubyArray = (RubyArray)file2.callMethod(context, "readlines", newArguments);
            return rubyArray;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        RubyString cmdObj;
        IRubyObject envHash;
        Ruby runtime = context.runtime;
        int firstArg = 0;
        int argc = args2.length;
        if (argc > 0 && !(envHash = TypeConverter.checkHashType(runtime, args2[0])).isNil()) {
            if (argc < 2) {
                throw runtime.newArgumentError(1, 2);
            }
            ++firstArg;
            --argc;
        } else {
            envHash = null;
        }
        if (Platform.IS_WINDOWS) {
            String[] tokens = args2[firstArg].convertToString().toString().split(" ", 2);
            String commandString = tokens[0].replace('/', '\\') + (tokens.length > 1 ? ' ' + tokens[1] : "");
            cmdObj = runtime.newString(commandString);
        } else {
            cmdObj = args2[firstArg].convertToString();
        }
        if ("-".equals(((Object)cmdObj).toString())) {
            throw runtime.newNotImplementedError("popen(\"-\") is unimplemented");
        }
        IOOptions ioOptions = argc == 1 ? RubyIO.newIOOptions(runtime, ModeFlags.RDONLY) : (args2[1] instanceof RubyFixnum ? RubyIO.newIOOptions(runtime, RubyFixnum.num2int(args2[firstArg + 1])) : RubyIO.newIOOptions(runtime, args2[firstArg + 1].convertToString().toString()));
        ShellLauncher.POpenProcess process = ShellLauncher.popen(runtime, cmdObj, (Map)((RubyHash)envHash), ioOptions.getModeFlags());
        if (System.getProperty("java.specification.version", "").equals("1.5")) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        RubyIO io2 = new RubyIO(runtime, process, ioOptions);
        if (recv2 instanceof RubyClass) {
            io2.setMetaClass((RubyClass)recv2);
        }
        if (!block.isGiven()) return io2;
        try {
            iRubyObject = block.yield(context, io2);
            if (!io2.openFile.isOpen()) return iRubyObject;
            io2.close();
        }
        catch (Throwable throwable) {
            try {
                if (!io2.openFile.isOpen()) throw throwable;
                io2.close();
                throw throwable;
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
        }
        return iRubyObject;
    }

    private void setupPopen(ModeFlags modes, ShellLauncher.POpenProcess process) throws RaiseException {
        this.openFile.setMode(modes.getOpenFileFlags() | 8);
        this.openFile.setProcess(process);
        try {
            if (this.openFile.isReadable()) {
                ReadableByteChannel inChannel = process.getInput() != null ? process.getInput() : Channels.newChannel(process.getInputStream());
                ChannelDescriptor main2 = new ChannelDescriptor(inChannel);
                main2.setCanBeSeekable(false);
                this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), main2));
            }
            if (this.openFile.isWritable() && process.hasOutput()) {
                WritableByteChannel outChannel = process.getOutput() != null ? process.getOutput() : Channels.newChannel(process.getOutputStream());
                ChannelDescriptor pipe2 = new ChannelDescriptor(outChannel);
                pipe2.setCanBeSeekable(false);
                if (this.openFile.getMainStream() != null) {
                    this.openFile.setPipeStream(ChannelStream.open(this.getRuntime(), pipe2));
                } else {
                    this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), pipe2));
                }
            }
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject popen19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Object object;
        ShellLauncher.POpenProcess process;
        Ruby runtime;
        block18: {
            IRubyObject tmp;
            runtime = context.runtime;
            IRubyObject pmode = null;
            RubyHash options2 = null;
            int firstArg = 0;
            int argc = args2.length;
            if (argc > 0 && !TypeConverter.checkHashType(runtime, args2[0]).isNil()) {
                ++firstArg;
                --argc;
            }
            if (argc > 0 && !(tmp = TypeConverter.checkHashType(runtime, args2[args2.length - 1])).isNil()) {
                options2 = (RubyHash)tmp;
                --argc;
            }
            if (argc > 1) {
                pmode = args2[firstArg + 1];
            }
            RubyIO io2 = new RubyIO(runtime, (RubyClass)recv2);
            io2.MakeOpenFile();
            IRubyObject[] pm = new IRubyObject[]{runtime.newFixnum(0), pmode};
            int[] oflags_p = new int[]{0};
            int[] fmode_p = new int[]{0};
            EncodingUtils.extractModeEncoding(context, io2, pm, options2, oflags_p, fmode_p);
            ModeFlags modes = ModeFlags.createModeFlags(oflags_p[0]);
            if (args2.length > 1 && args2[args2.length - 1] instanceof RubyHash) {
                options2 = (RubyHash)args2[args2.length - 1];
                IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
                System.arraycopy(args2, 0, newArgs, 0, args2.length - 1);
                args2 = newArgs;
            }
            Ruby19POpen r19Popen = new Ruby19POpen(runtime, args2);
            if ("-".equals(r19Popen.cmd.toString())) {
                throw runtime.newNotImplementedError("popen(\"-\") is unimplemented");
            }
            process = r19Popen.cmdPlusArgs == null ? ShellLauncher.popen(runtime, (IRubyObject)r19Popen.cmd, modes) : ShellLauncher.popen(runtime, r19Popen.cmdPlusArgs, (Map)r19Popen.env, modes);
            if (System.getProperty("java.specification.version", "").equals("1.5")) {
                object = process;
                synchronized (object) {
                    try {
                        process.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            RubyIO.checkPopenOptions(options2);
            io2.setupPopen(modes, process);
            if (!block.isGiven()) return io2;
            try {
                object = block.yield(context, io2);
                if (!io2.openFile.isOpen()) break block18;
                io2.close();
            }
            catch (Throwable throwable) {
                try {
                    if (io2.openFile.isOpen()) {
                        io2.close();
                    }
                    context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
                    throw throwable;
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
                catch (InterruptedException e) {
                    throw runtime.newThreadError("unexpected interrupt");
                }
            }
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(rest=true, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject popen3(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        Ruby runtime = context.runtime;
        POpenTuple tuple = RubyIO.popenSpecial(context, args2);
        RubyArray yieldArgs = RubyArray.newArrayLight(runtime, tuple.output, tuple.input, tuple.error);
        if (!block.isGiven()) return yieldArgs;
        try {
            iRubyObject = block.yield(context, yieldArgs);
        }
        catch (Throwable throwable) {
            try {
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        RubyIO.cleanupPOpen(tuple);
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"popen3"}, rest=true, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject popen3_19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyThread[] waitThread;
        final Ruby runtime = context.runtime;
        final POpenTuple tuple = RubyIO.popenSpecial(context, args2);
        final long pid2 = ShellLauncher.getPidFromProcess(tuple.process);
        waitThread = new RubyThread[]{new RubyThread(runtime, (RubyClass)runtime.getClassFromPath("Process::WaitThread"), new ThreadedRunnable(){
            volatile Thread javaThread;

            @Override
            public Thread getJavaThread() {
                return this.javaThread;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RubyThread rubyThread;
                this.javaThread = Thread.currentThread();
                while ((rubyThread = waitThread[0]) == null) {
                    Thread.yield();
                }
                ThreadContext context = runtime.getThreadService().registerNewThread(rubyThread);
                rubyThread.op_aset(runtime.newSymbol("pid"), runtime.newFixnum(pid2));
                try {
                    int exitValue = tuple.process.waitFor();
                    RubyProcess.RubyStatus status2 = RubyProcess.RubyStatus.newProcessStatus(runtime, exitValue, pid2);
                    rubyThread.cleanTerminate(status2);
                }
                catch (Throwable t) {
                    rubyThread.exceptionRaised(t);
                }
                finally {
                    rubyThread.dispose();
                }
            }
        })};
        RubyArray yieldArgs = RubyArray.newArrayLight(runtime, tuple.output, tuple.input, tuple.error, waitThread[0]);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, yieldArgs);
                return iRubyObject;
            }
            finally {
                RubyIO.cleanupPOpen(tuple);
                IRubyObject status2 = waitThread[0].join(IRubyObject.NULL_ARRAY);
                context.setLastExitStatus(status2);
            }
        }
        return yieldArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject popen4(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        Ruby runtime = context.runtime;
        POpenTuple tuple = RubyIO.popenSpecial(context, args2);
        RubyArray yieldArgs = RubyArray.newArrayLight(runtime, runtime.newFixnum(ShellLauncher.getPidFromProcess(tuple.process)), tuple.output, tuple.input, tuple.error);
        if (!block.isGiven()) return yieldArgs;
        try {
            iRubyObject = block.yield(context, yieldArgs);
        }
        catch (Throwable throwable) {
            try {
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        RubyIO.cleanupPOpen(tuple);
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
        return iRubyObject;
    }

    private static void cleanupPOpen(POpenTuple tuple) {
        if (tuple.input.openFile.isOpen()) {
            try {
                tuple.input.close();
            }
            catch (RaiseException re) {
                // empty catch block
            }
        }
        if (tuple.output.openFile.isOpen()) {
            try {
                tuple.output.close();
            }
            catch (RaiseException re) {
                // empty catch block
            }
        }
        if (tuple.error.openFile.isOpen()) {
            try {
                tuple.error.close();
            }
            catch (RaiseException raiseException) {
                // empty catch block
            }
        }
    }

    public static POpenTuple popenSpecial(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        try {
            ShellLauncher.POpenProcess process = ShellLauncher.popen3(runtime, args2, false);
            RubyIO input = process.getInput() != null ? new RubyIO(runtime, process.getInput()) : new RubyIO(runtime, process.getInputStream());
            RubyIO output = process.getOutput() != null ? new RubyIO(runtime, process.getOutput()) : new RubyIO(runtime, process.getOutputStream());
            RubyIO error2 = process.getError() != null ? new RubyIO(runtime, process.getError()) : new RubyIO(runtime, process.getErrorStream());
            input.getOpenFile().setProcess(process);
            output.getOpenFile().setProcess(process);
            error2.getOpenFile().setProcess(process);
            input.popenSpecial = true;
            output.popenSpecial = true;
            error2.popenSpecial = true;
            input.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            output.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            error2.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            return new POpenTuple(input, output, error2, process);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject pipe(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        try {
            Pipe pipe2 = Pipe.open();
            RubyIO source2 = new RubyIO(runtime, pipe2.source());
            RubyIO sink = new RubyIO(runtime, pipe2.sink());
            sink.openFile.getMainStreamSafe().setSync(true);
            return runtime.newArrayNoCopy(source2, sink);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2) {
        return RubyIO.pipe19(context, recv2, context.nil, context.nil);
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2, IRubyObject modes) {
        return RubyIO.pipe19(context, recv2, modes, context.nil);
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2, IRubyObject modes, IRubyObject options2) {
        Ruby runtime = context.runtime;
        try {
            Pipe pipe2 = Pipe.open();
            RubyIO source2 = new RubyIO(runtime, pipe2.source());
            source2.setEncoding(context, modes, context.nil, options2);
            RubyIO sink = new RubyIO(runtime, pipe2.sink());
            sink.openFile.getMainStreamSafe().setSync(true);
            return runtime.newArrayNoCopy(source2, sink);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"copy_stream"}, required=2, optional=2, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject arg1 = args2[0];
        IRubyObject arg2 = args2[1];
        RubyInteger length2 = null;
        RubyInteger offset2 = null;
        RubyIO io1 = null;
        RubyIO io2 = null;
        RubyString read2 = null;
        if (args2.length >= 3) {
            length2 = args2[2].convertToInteger();
            if (args2.length == 4) {
                offset2 = args2[3].convertToInteger();
            }
        }
        try {
            RubyString path2;
            if (arg1 instanceof RubyString) {
                io1 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{arg1}, Block.NULL_BLOCK);
            } else if (arg1 instanceof RubyIO) {
                io1 = (RubyIO)arg1;
            } else if (arg1.respondsTo("to_path")) {
                path2 = (RubyString)TypeConverter.convertToType19(arg1, runtime.getString(), "to_path");
                io1 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{path2}, Block.NULL_BLOCK);
            } else if (arg1.respondsTo("read")) {
                read2 = length2 == null ? arg1.callMethod(context, "read", runtime.getNil()).convertToString() : arg1.callMethod(context, "read", length2).convertToString();
            } else {
                throw runtime.newArgumentError("Should be String or IO");
            }
            if (arg2 instanceof RubyString) {
                io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{arg2, runtime.newString("w")}, Block.NULL_BLOCK);
            } else if (arg2 instanceof RubyIO) {
                io2 = (RubyIO)arg2;
            } else if (arg2.respondsTo("to_path")) {
                path2 = (RubyString)TypeConverter.convertToType19(arg2, runtime.getString(), "to_path");
                io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{path2, runtime.newString("w")}, Block.NULL_BLOCK);
            } else {
                if (arg2.respondsTo("write")) {
                    if (read2 == null) {
                        read2 = length2 == null ? io1.read(context, runtime.getNil()).convertToString() : io1.read(context, length2).convertToString();
                    }
                    return arg2.callMethod(context, "write", read2);
                }
                throw runtime.newArgumentError("Should be String or IO");
            }
            if (io1 == null) {
                IRubyObject size2 = io2.write(context, read2);
                io2.flush();
                return size2;
            }
            if (!io1.openFile.isReadable()) {
                throw runtime.newIOError("from IO is not readable");
            }
            if (!io2.openFile.isWritable()) {
                throw runtime.newIOError("to IO is not writable");
            }
            ChannelDescriptor d1 = io1.openFile.getMainStreamSafe().getDescriptor();
            ChannelDescriptor d2 = io2.openFile.getWriteStreamSafe().getDescriptor();
            try {
                long size3 = 0L;
                if (!d1.isSeekable()) {
                    if (!d2.isSeekable()) {
                        ReadableByteChannel from = (ReadableByteChannel)d1.getChannel();
                        WritableByteChannel to = (WritableByteChannel)d2.getChannel();
                        size3 = RubyIO.transfer(context, from, to);
                    } else {
                        ReadableByteChannel from = (ReadableByteChannel)d1.getChannel();
                        FileChannel to = (FileChannel)d2.getChannel();
                        size3 = RubyIO.transfer(from, to);
                    }
                } else {
                    FileChannel from = (FileChannel)d1.getChannel();
                    WritableByteChannel to = (WritableByteChannel)d2.getChannel();
                    long remaining = length2 == null ? from.size() : length2.getLongValue();
                    long position = offset2 == null ? from.position() : offset2.getLongValue();
                    size3 = RubyIO.transfer(from, to, remaining, position);
                    if (offset2 == null) {
                        from.position(from.position() + size3);
                    }
                }
                return context.runtime.newFixnum(size3);
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
    }

    private static long transfer(ReadableByteChannel from, FileChannel to) throws IOException {
        long bytes2;
        long transferred = 0L;
        long startPosition = to.position();
        while ((bytes2 = to.transferFrom(from, startPosition + transferred, 4196L)) > 0L) {
            transferred += bytes2;
        }
        return transferred;
    }

    private static long transfer(FileChannel from, WritableByteChannel to, long remaining, long position) throws IOException {
        long count2;
        long n;
        long chunkSize = 0x8000000L;
        long transferred = 0L;
        while (remaining > 0L && (n = from.transferTo(position, count2 = Math.min(remaining, chunkSize), to)) != 0L) {
            position += n;
            remaining -= n;
            transferred += n;
        }
        return transferred;
    }

    private static long transfer(ThreadContext context, ReadableByteChannel from, WritableByteChannel to) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
        long transferred = 0L;
        while (from.isOpen()) {
            context.pollThreadEvents();
            long n = from.read(buffer);
            if (n == -1L) break;
            buffer.flip();
            to.write(buffer);
            buffer.clear();
            transferred += n;
        }
        return transferred;
    }

    @JRubyMethod(name={"try_convert"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject tryConvert(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return arg2.respondsTo("to_io") ? RubyIO.convertToIO(context, arg2) : context.runtime.getNil();
    }

    private static ByteList getNilByteList(Ruby runtime) {
        return runtime.is1_9() ? ByteList.EMPTY_BYTELIST : NIL_BYTELIST;
    }

    public synchronized void addBlockingThread(RubyThread thread2) {
        if (this.blockingThreads == null) {
            this.blockingThreads = new ArrayList<RubyThread>(1);
        }
        this.blockingThreads.add(thread2);
    }

    public synchronized void removeBlockingThread(RubyThread thread2) {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i2 = 0; i2 < this.blockingThreads.size(); ++i2) {
            if (this.blockingThreads.get(i2) != thread2) continue;
            this.blockingThreads.remove(i2);
        }
    }

    protected synchronized void interruptBlockingThreads() {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i2 = 0; i2 < this.blockingThreads.size(); ++i2) {
            RubyThread thread2 = this.blockingThreads.get(i2);
            thread2.raise(new IRubyObject[]{this.getRuntime().newIOError("stream closed").getException()}, Block.NULL_BLOCK);
        }
    }

    protected final IOOptions updateIOOptionsFromOptions(ThreadContext context, RubyHash options2, IOOptions ioOptions) {
        if (options2 == null || options2.isNil()) {
            return ioOptions;
        }
        Ruby runtime = context.runtime;
        if (options2.containsKey(runtime.newSymbol("mode"))) {
            ioOptions = this.parseIOOptions19(options2.fastARef(runtime.newSymbol("mode")));
        }
        if (options2.containsKey(runtime.newSymbol("binmode")) && options2.fastARef(runtime.newSymbol("binmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, ModeFlags.BINARY);
        }
        if (options2.containsKey(runtime.newSymbol("binmode")) && options2.fastARef(runtime.newSymbol("binmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, ModeFlags.BINARY);
        }
        if (options2.containsKey(runtime.newSymbol("textmode")) && options2.fastARef(runtime.newSymbol("textmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, 0x10000000);
        }
        if (options2.containsKey(runtime.newSymbol("open_args"))) {
            IRubyObject args2 = options2.fastARef(runtime.newSymbol("open_args"));
            RubyArray openArgs = args2.convertToArray();
            for (int i2 = 0; i2 < openArgs.size(); ++i2) {
                IRubyObject arg2 = openArgs.eltInternal(i2);
                if (arg2 instanceof RubyString) {
                    ioOptions = RubyIO.newIOOptions(runtime, arg2.asJavaString());
                    continue;
                }
                if (arg2 instanceof RubyFixnum) {
                    ioOptions = RubyIO.newIOOptions(runtime, ((RubyFixnum)arg2).getLongValue());
                    continue;
                }
                if (!(arg2 instanceof RubyHash)) continue;
                ioOptions = this.updateIOOptionsFromOptions(context, (RubyHash)arg2, ioOptions);
            }
        }
        EncodingUtils.ioExtractEncodingOption(context, this, options2, null);
        return ioOptions;
    }

    public Encoding encodingFromBOM() {
        return EncodingUtils.ioStripBOM(this);
    }

    public static void checkExecOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported exec option");
        RubyIO.checkValidOptions(options2, ALL_SPAWN_OPTIONS);
    }

    public static void checkSpawnOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported spawn option");
        RubyIO.checkValidOptions(options2, ALL_SPAWN_OPTIONS);
    }

    public static void checkPopenOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported popen option");
    }

    private static void checkUnsupportedOptions(IRubyObject options2, Set<String> unsupported, String error2) {
        if (options2 == null || options2.isNil() || !(options2 instanceof RubyHash)) {
            return;
        }
        RubyHash optsHash = (RubyHash)options2;
        Ruby runtime = optsHash.getRuntime();
        for (String key2 : unsupported) {
            if (!optsHash.containsKey(runtime.newSymbol(key2))) continue;
            runtime.getWarnings().warn(error2 + ": " + key2);
        }
    }

    private static void checkValidOptions(IRubyObject options2, Set<String> valid) {
        if (options2 == null || options2.isNil() || !(options2 instanceof RubyHash)) {
            return;
        }
        RubyHash optsHash = (RubyHash)options2;
        Ruby runtime = optsHash.getRuntime();
        for (Object opt : optsHash.keySet()) {
            if (opt instanceof RubySymbol || opt instanceof RubyFixnum || opt instanceof RubyArray || valid.contains(opt.toString())) continue;
            throw runtime.newTypeError("wrong exec option: " + opt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obliterateProcess(Process process) {
        int i2 = 0;
        Object waitLock = new Object();
        while (true) {
            if (i2 >= 1000) {
                return;
            }
            process.destroy();
            try {
                process.exitValue();
                break;
            }
            catch (IllegalThreadStateException itse) {
                ++i2;
                Object object = waitLock;
                synchronized (object) {
                    try {
                        waitLock.wait(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime, long mode2) {
        return RubyIO.newModeFlags(runtime, (int)mode2);
    }

    public static ModeFlags newModeFlags(Ruby runtime, int mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime, String mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, ModeFlags modeFlags) {
        return new IOOptions(modeFlags);
    }

    public static IOOptions newIOOptions(Ruby runtime, long mode2) {
        return RubyIO.newIOOptions(runtime, (int)mode2);
    }

    public static IOOptions newIOOptions(Ruby runtime, int mode2) {
        try {
            ModeFlags modeFlags = new ModeFlags(mode2);
            return new IOOptions(modeFlags);
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, String mode2) {
        try {
            return new IOOptions(runtime, mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, IOOptions oldFlags, int orOflags) {
        try {
            return new IOOptions(new ModeFlags(oldFlags.getModeFlags().getFlags() | orOflags));
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public boolean writeDataBuffered() {
        return this.openFile.getMainStream().writeDataBuffered();
    }

    @Deprecated
    public void registerDescriptor(ChannelDescriptor descriptor, boolean isRetained) {
    }

    @Deprecated
    public void registerDescriptor(ChannelDescriptor descriptor) {
    }

    @Deprecated
    public void unregisterDescriptor(int aFileno) {
    }

    @Deprecated
    public ChannelDescriptor getDescriptorByFileno(int aFileno) {
        return ChannelDescriptor.getDescriptorByFileno(aFileno);
    }

    @Deprecated
    public static int getNewFileno() {
        return ChannelDescriptor.getNewFileno();
    }

    @Deprecated
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.gets(context) : this.gets(context, args2[0]);
    }

    @Deprecated
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.readline(context) : this.readline(context, args2[0]);
    }

    private IRubyObject doWriteConversion(ThreadContext context, IRubyObject str) {
        Ruby runtime = context.runtime;
        if (!this.needsWriteConversion(context)) {
            return str;
        }
        IRubyObject commonEncoding = context.nil;
        this.openFile.setBinmode();
        this.makeWriteConversion(context);
        if (this.writeconv != null) {
            if (!this.writeconvAsciicompat.isNil()) {
                commonEncoding = this.writeconvAsciicompat;
            }
        } else if (this.enc2 != null) {
            commonEncoding = runtime.getEncodingService().convertEncodingToRubyEncoding(this.enc2);
        } else if (this.enc != runtime.getEncodingService().getAscii8bitEncoding()) {
            commonEncoding = runtime.getEncodingService().convertEncodingToRubyEncoding(this.enc);
        }
        if (!commonEncoding.isNil()) {
            str = EncodingUtils.rbStrEncode(context, str, commonEncoding, this.writeconvPreEcflags, this.writeconvPreEcopts);
        }
        if (this.writeconv != null) {
            str = runtime.newString(this.writeconv.econvStrConvert(context, ((RubyString)str).getByteList(), false));
        }
        return str;
    }

    private boolean needsReadConversion() {
        return this.enc2 != null || (this.ecflags & 0xFFFFEFFF) != 0;
    }

    private boolean needsWriteConversion(ThreadContext context) {
        Encoding ascii8bit = context.runtime.getEncodingService().getAscii8bitEncoding();
        return this.enc != null && this.enc != ascii8bit || this.openFile.isTextMode() || (this.ecflags & 0xF0EF00) != 0;
    }

    private void makeReadConversion(ThreadContext context) {
        byte[] dname;
        byte[] sname;
        if (this.readconv != null) {
            return;
        }
        int ecflags = this.ecflags & 0xFFFFCFFF;
        IRubyObject ecopts = this.ecopts;
        if (this.enc2 != null) {
            sname = this.enc2.getName();
            dname = this.enc.getName();
        } else {
            dname = EMPTY_BYTE_ARRAY;
            sname = EMPTY_BYTE_ARRAY;
        }
        this.readconv = EncodingUtils.econvOpenOpts(context, sname, dname, ecflags, ecopts);
        if (this.readconv == null) {
            throw EncodingUtils.econvOpenExc(context, sname, dname, ecflags);
        }
    }

    private void makeWriteConversion(ThreadContext context) {
        if (this.writeconvInitialized) {
            return;
        }
        this.writeconvInitialized = true;
        int ecflags = this.ecflags & 0xFFFFF0FF;
        IRubyObject ecopts = this.ecopts;
        Encoding ascii8bit = context.runtime.getEncodingService().getAscii8bitEncoding();
        if (this.enc == null || this.enc == ascii8bit && this.enc2 == null) {
            this.writeconvPreEcflags = 0;
            this.writeconvPreEcopts = context.nil;
            this.writeconv = EncodingUtils.econvOpenOpts(context, EMPTY_BYTE_ARRAY, EMPTY_BYTE_ARRAY, ecflags, ecopts);
            if (this.writeconv == null) {
                throw EncodingUtils.econvOpenExc(context, EMPTY_BYTE_ARRAY, EMPTY_BYTE_ARRAY, ecflags);
            }
            this.writeconvAsciicompat = context.nil;
        } else {
            byte[] senc;
            Encoding enc = this.enc2 != null ? this.enc2 : this.enc;
            Encoding tmpEnc = EncodingUtils.econvAsciicompatEncoding(enc);
            byte[] byArray = senc = tmpEnc == null ? null : tmpEnc.getName();
            if (senc == null && (this.ecflags & 0xF00000) == 0) {
                this.writeconvPreEcflags = ecflags;
                this.writeconvPreEcopts = ecopts;
                this.writeconv = null;
                this.writeconvAsciicompat = context.nil;
            } else {
                byte[] denc;
                this.writeconvPreEcflags = ecflags & 0xFF0FFFFF;
                this.writeconvPreEcopts = ecopts;
                if (senc != null) {
                    denc = enc.getName();
                    this.writeconvAsciicompat = RubyString.newString(context.runtime, senc);
                } else {
                    denc = EMPTY_BYTE_ARRAY;
                    senc = EMPTY_BYTE_ARRAY;
                    this.writeconvAsciicompat = RubyString.newString(context.runtime, enc.getName());
                }
                ecflags = this.ecflags & 0xF000FF;
                ecopts = this.ecopts;
                this.writeconv = EncodingUtils.econvOpenOpts(context, senc, denc, ecflags, ecopts);
                if (this.writeconv == null) {
                    throw EncodingUtils.econvOpenExc(context, senc, denc, ecflags);
                }
            }
        }
    }

    private void clearReadConversion() {
        this.readconv = null;
    }

    private void clearCodeConversion() {
        this.readconv = null;
        this.writeconv = null;
    }

    @Override
    public void setEnc2(Encoding enc2) {
        this.enc2 = enc2;
    }

    @Override
    public void setEnc(Encoding enc) {
        this.enc = enc;
    }

    @Override
    public void setEcflags(int ecflags) {
        this.ecflags = ecflags;
    }

    @Override
    public int getEcflags() {
        return this.ecflags;
    }

    @Override
    public void setEcopts(IRubyObject ecopts) {
        this.ecopts = ecopts;
    }

    @Override
    public IRubyObject getEcopts() {
        return this.ecopts;
    }

    @Override
    public void setBOM(boolean bom) {
        this.hasBom = bom;
    }

    @Override
    public boolean getBOM() {
        return this.hasBom;
    }

    protected void setAscii8bitBinmode() {
        Encoding ascii8bit = this.getRuntime().getEncodingService().getAscii8bitEncoding();
        if (this.readconv != null) {
            this.readconv = null;
        }
        if (this.writeconv != null) {
            this.writeconv = null;
        }
        this.openFile.setBinmode();
        this.openFile.clearTextMode();
        this.enc = ascii8bit;
        this.enc2 = null;
        this.ecflags = 0;
        this.ecopts = this.getRuntime().getNil();
        this.clearCodeConversion();
    }

    protected void MakeOpenFile() {
        if (this.openFile != null) {
            Ruby runtime = this.getRuntime();
            this.ioClose(runtime);
            this.openFile.finalize(runtime, false);
            this.openFile = null;
        }
        this.openFile = new OpenFile();
    }

    @Deprecated
    public IRubyObject getline(Ruby runtime, ByteList separator) {
        return this.getline(runtime.getCurrentContext(), separator, -1L, null);
    }

    @Deprecated
    public IRubyObject getline(Ruby runtime, ByteList separator, long limit2) {
        return this.getline(runtime.getCurrentContext(), separator, limit2, null);
    }

    static /* synthetic */ byte[] access$100() {
        return EMPTY_BYTE_ARRAY;
    }

    static {
        String v = SafePropertyAccessor.getProperty("java.vendor");
        vendor = v == null ? "" : v;
        msgEINTR = "Interrupted system call";
        NIL_BYTELIST = ByteList.create((CharSequence)"nil");
        RECURSIVE_BYTELIST = ByteList.create((CharSequence)"[...]");
        EMPTY_BYTE_ARRAY = new byte[0];
        UNSUPPORTED_SPAWN_OPTIONS = new HashSet<String>(Arrays.asList("unsetenv_others", "prgroup", "new_pgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"));
        ALL_SPAWN_OPTIONS = new HashSet<String>(Arrays.asList("unsetenv_others", "prgroup", "new_pgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"));
    }

    private static class ByteListCache {
        private byte[] buffer = RubyIO.access$100();

        private ByteListCache() {
        }

        public void release(ByteList l) {
            this.buffer = l.getUnsafeBytes();
        }

        public ByteList allocate(int size2) {
            ByteList l = new ByteList(this.buffer, 0, size2, false);
            return l;
        }
    }

    private static class POpenTuple {
        public final RubyIO input;
        public final RubyIO output;
        public final RubyIO error;
        public final Process process;

        public POpenTuple(RubyIO i2, RubyIO o, RubyIO e, Process p2) {
            this.input = i2;
            this.output = o;
            this.error = e;
            this.process = p2;
        }
    }

    private static class Ruby19POpen {
        public final RubyString cmd;
        public final IRubyObject[] cmdPlusArgs;
        public final RubyHash env;

        public Ruby19POpen(Ruby runtime, IRubyObject[] args2) {
            IRubyObject _cmd;
            IRubyObject[] _cmdPlusArgs = null;
            IRubyObject _env = null;
            int firstArg = 0;
            int argc = args2.length;
            if (argc > 0 && !(_env = TypeConverter.checkHashType(runtime, args2[0])).isNil()) {
                if (argc < 2) {
                    throw runtime.newArgumentError(1, 2);
                }
                ++firstArg;
                --argc;
            } else {
                _env = null;
            }
            IRubyObject arg0 = args2[firstArg].checkArrayType();
            if (arg0.isNil()) {
                arg0 = TypeConverter.checkStringType(runtime, args2[firstArg]);
                if (arg0.isNil()) {
                    throw runtime.newTypeError(args2[firstArg], runtime.getString());
                }
                _cmdPlusArgs = null;
                _cmd = arg0;
            } else {
                RubyArray arg0Ary = (RubyArray)arg0;
                if (arg0Ary.isEmpty()) {
                    throw runtime.newArgumentError("wrong number of arguments");
                }
                if (arg0Ary.eltOk(0L) instanceof RubyHash) {
                    _env = arg0Ary.delete_at(0);
                }
                if (arg0Ary.isEmpty()) {
                    throw runtime.newArgumentError("wrong number of arguments");
                }
                if (arg0Ary.size() > 1 && arg0Ary.eltOk(arg0Ary.size() - 1) instanceof RubyHash) {
                    _env = arg0Ary.eltOk(arg0Ary.size() - 1);
                }
                _cmdPlusArgs = arg0Ary.toJavaArray();
                _cmd = _cmdPlusArgs[0];
            }
            if (Platform.IS_WINDOWS) {
                String commandString = _cmd.convertToString().toString().replace('/', '\\');
                _cmd = runtime.newString(commandString);
                if (_cmdPlusArgs != null) {
                    _cmdPlusArgs[0] = _cmd;
                }
            } else {
                _cmd = _cmd.convertToString();
                if (_cmdPlusArgs != null) {
                    _cmdPlusArgs[0] = _cmd;
                }
            }
            this.cmd = (RubyString)_cmd;
            this.cmdPlusArgs = _cmdPlusArgs;
            this.env = (RubyHash)_env;
        }
    }
}

