/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.io.PrintWriter;
import java.util.Stack;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.MethodData;
import org.jruby.objectweb.asm.ClassVisitor;
import org.jruby.objectweb.asm.ClassWriter;
import org.jruby.objectweb.asm.Type;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JVM {
    private static final Logger LOG = LoggerFactory.getLogger("IRBuilder");
    Stack<ClassData> clsStack = new Stack();
    ClassWriter writer;
    public static final int CMP_EQ = 0;
    public static final Class OBJECT = IRubyObject.class;
    public static final Class BLOCK = Block.class;
    public static final Class THREADCONTEXT = ThreadContext.class;
    public static final Class STATICSCOPE = StaticScope.class;
    public static final Type OBJECT_TYPE = Type.getType(OBJECT);
    public static final Type BLOCK_TYPE = Type.getType(BLOCK);
    public static final Type THREADCONTEXT_TYPE = Type.getType(THREADCONTEXT);
    public static final Type STATICSCOPE_TYPE = Type.getType(STATICSCOPE);

    public byte[] code() {
        return this.writer.toByteArray();
    }

    public ClassVisitor cls() {
        return this.clsData().cls;
    }

    public ClassData clsData() {
        return this.clsStack.peek();
    }

    public MethodData methodData() {
        return this.clsData().methodData();
    }

    public void pushclass(String clsName) {
        PrintWriter pw = new PrintWriter(System.out);
        this.clsStack.push(new ClassData(clsName, new ClassWriter(3)));
        pw.flush();
    }

    public void pushscript(String clsName, String filename2) {
        PrintWriter pw = new PrintWriter(System.out);
        this.writer = new ClassWriter(3);
        this.clsStack.push(new ClassData(clsName, this.writer));
        this.cls().visit(RubyInstanceConfig.JAVA_VERSION, 33, clsName, null, CodegenUtils.p(Object.class), null);
        this.cls().visitSource(filename2, null);
        pw.flush();
    }

    public void popclass() {
        this.clsStack.pop();
    }

    public IRBytecodeAdapter method() {
        return this.clsData().method();
    }

    public void pushmethod(String name2, int arity2) {
        this.clsData().pushmethod(name2, arity2);
        this.method().startMethod();
        this.methodData().local("$context", THREADCONTEXT_TYPE);
        this.methodData().local("$scope", STATICSCOPE_TYPE);
        this.methodData().local("$self");
        for (int i2 = 0; i2 < arity2; ++i2) {
            this.methodData().local("$argument" + i2);
        }
        this.methodData().local("$block", Type.getType(Block.class));
        this.methodData().local("$dynamicScope");
    }

    public void popmethod() {
        this.clsData().popmethod();
    }

    public static String scriptToClass(String name2) {
        if (name2.equals("-e")) {
            return "DashE";
        }
        return JavaNameMangler.mangledFilenameForStartupClasspath(name2);
    }

    public void declareField(String field2) {
        if (!this.clsData().fieldSet.contains(field2)) {
            this.cls().visitField(4, field2, CodegenUtils.ci(Object.class), null, null);
            this.clsData().fieldSet.add(field2);
        }
    }
}

