/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.schedulers.cron;

import java.text.ParseException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.modules.schedulers.cron.CronJob;
import org.mule.modules.schedulers.i18n.SchedulerMessages;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.polling.schedule.PollScheduler;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class CronScheduler
extends PollScheduler<PollingReceiverWorker>
implements MuleContextAware {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String THREAD_POLL_CLASS_PROPERTY = "org.quartz.threadPool.class";
    public static final String THREAD_POLL_CLASS = "org.quartz.simpl.SimpleThreadPool";
    public static final String THREAD_POOL_COUNT_PROPERTY = "org.quartz.threadPool.threadCount";
    public static final String POLL_CRON_SCHEDULER_JOB = "poll.scheduler.job";
    private Scheduler quartzScheduler;
    private MuleContext context;
    private String cronExpression;
    private String jobName;
    private String groupName;

    public CronScheduler(String name, PollingReceiverWorker job, String cronExpression) {
        super(name, (Runnable)job);
        this.cronExpression = cronExpression;
    }

    public void schedule() throws Exception {
        this.quartzScheduler.triggerJob(this.jobName, this.groupName);
    }

    public void dispose() {
        try {
            this.quartzScheduler.shutdown();
        }
        catch (SchedulerException e) {
            this.logger.error((Object)SchedulerMessages.couldNotShutdownScheduler(), (Throwable)e);
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.quartzScheduler = this.createScheduler();
            this.jobName = ((PollingReceiverWorker)this.job).getReceiver().getReceiverKey();
            this.groupName = ((PollingReceiverWorker)this.job).getReceiver().getEndpoint().getName();
            this.quartzScheduler.addJob(this.jobDetail(this.jobName, this.groupName, (PollingReceiverWorker)this.job), true);
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            throw new InitialisationException(SchedulerMessages.couldNotCreateScheduler(), (Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        try {
            if (this.quartzScheduler.isStarted()) {
                if (this.quartzScheduler.getTrigger(this.getName(), this.groupName) == null) {
                    CronTrigger cronTrigger = new CronTrigger(this.getName(), this.groupName, this.jobName, this.groupName, this.cronExpression);
                    this.quartzScheduler.scheduleJob((Trigger)cronTrigger);
                } else {
                    this.quartzScheduler.resumeAll();
                }
            }
        }
        catch (SchedulerException e) {
            throw new DefaultMuleException(SchedulerMessages.couldNotScheduleJob(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new DefaultMuleException(SchedulerMessages.invalidCronExpression(), (Throwable)e);
        }
    }

    public void stop() throws MuleException {
        try {
            this.quartzScheduler.pauseAll();
        }
        catch (SchedulerException e) {
            throw new DefaultMuleException(SchedulerMessages.couldNotPauseSchedulers(), (Throwable)e);
        }
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    private JobDetail jobDetail(String jobName, String groupName, PollingReceiverWorker job) {
        JobDetail jobDetail = new JobDetail(jobName, groupName, CronJob.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)POLL_CRON_SCHEDULER_JOB, (Object)job);
        jobDetail.setJobDataMap(jobDataMap);
        return jobDetail;
    }

    private Scheduler createScheduler() throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory(this.withFactoryProperties());
        return factory.getScheduler();
    }

    private Properties withFactoryProperties() {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty(THREAD_POLL_CLASS_PROPERTY, THREAD_POLL_CLASS);
        factoryProperties.setProperty(THREAD_POOL_COUNT_PROPERTY, String.valueOf(this.context.getDefaultMessageReceiverThreadingProfile().getMaxThreadsActive()));
        return factoryProperties;
    }
}

