/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.routing;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.module.rss.routing.EntryLastUpdatedFilter;
import org.mule.module.rss.transformers.ObjectToRssFeed;
import org.mule.routing.AbstractSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedSplitter
extends AbstractSplitter {
    protected final transient Log logger = LogFactory.getLog(FeedSplitter.class);
    public static final String FEED_PROPERTY = "feed.object";
    private Filter entryFilter;
    private ObjectToRssFeed objectToFeed = new ObjectToRssFeed();

    public FeedSplitter() {
        this.entryFilter = new EntryLastUpdatedFilter(null);
    }

    protected List<MuleMessage> splitMessage(MuleEvent event) throws MuleException {
        this.setMuleContext(event.getMuleContext());
        ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
        if ((Integer)event.getMessage().getInboundProperty("Content-Length", (Object)-1) == 0) {
            this.logger.info((Object)"Feed has no content, ignoring");
            return messages;
        }
        try {
            Object payload = event.getMessage().getPayload();
            SyndFeed feed = payload instanceof SyndFeed ? (SyndFeed)payload : (SyndFeed)this.objectToFeed.transform(event.getMessage().getPayload());
            TreeSet<SyndEntry> entries = new TreeSet<SyndEntry>(new EntryComparator());
            entries.addAll(feed.getEntries());
            for (SyndEntry entry : entries) {
                DefaultMuleMessage m = new DefaultMuleMessage((Object)entry, event.getMuleContext());
                if (this.entryFilter != null && !this.entryFilter.accept((MuleMessage)m)) continue;
                m.setInvocationProperty(FEED_PROPERTY, (Object)feed);
                messages.add((MuleMessage)m);
            }
            return messages;
        }
        catch (MuleException e) {
            throw new MessagingException(e.getI18nMessage(), event, (Throwable)e);
        }
    }

    public Filter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Filter entryFilter) {
        this.entryFilter = entryFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryComparator
    implements Comparator<SyndEntry> {
        EntryComparator() {
        }

        @Override
        public int compare(SyndEntry e1, SyndEntry e2) {
            if (e1.getPublishedDate().before(e2.getPublishedDate())) {
                return -1;
            }
            if (e1.equals(e2)) {
                return 0;
            }
            return 1;
        }
    }
}

