/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp.i18n;

import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;

public class PGPMessages
extends MessageFactory {
    private static final PGPMessages factory = new PGPMessages();
    private static final String BUNDLE_PATH = PGPMessages.getBundlePath((String)"pgp");

    public static Message noPublicKeyForUser(String userId) {
        return factory.createMessage(BUNDLE_PATH, 1, userId);
    }

    public static Message invalidSignature() {
        return factory.createMessage(BUNDLE_PATH, 3);
    }

    public static Message errorVerifySignature() {
        return factory.createMessage(BUNDLE_PATH, 4);
    }

    public static Message encryptionStrategyNotSet() {
        return factory.createMessage(BUNDLE_PATH, 5);
    }

    public static Message pgpPublicKeyExpired() {
        return factory.createMessage(BUNDLE_PATH, 6);
    }

    public static Message noPublicKeyForPrincipal(String principalId) {
        return factory.createMessage(BUNDLE_PATH, 8, principalId);
    }

    public static Message noFileKeyFound(String path) {
        return factory.createMessage(BUNDLE_PATH, 9, path);
    }

    public static Message noSecretKeyDefined() {
        return factory.createMessage(BUNDLE_PATH, 10);
    }

    public static Message noSecretPassPhrase() {
        return factory.createMessage(BUNDLE_PATH, 11);
    }

    public static Message noKeyIdFound(String id) {
        return factory.createMessage(BUNDLE_PATH, 12, id);
    }

    public static Message noPublicKeyDefined() {
        return factory.createMessage(BUNDLE_PATH, 13);
    }
}

