/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import org.mule.module.pgp.AbstractTransformPolicy;

public class TransformContinuouslyPolicy
extends AbstractTransformPolicy {
    public static final long DEFAULT_CHUNK_SIZE = 0x1000000L;
    private long chunkSize;

    public TransformContinuouslyPolicy() {
        this(0x1000000L);
    }

    public TransformContinuouslyPolicy(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public void readRequest(long length) {
        this.startCopyingThread();
    }

    @Override
    protected Thread getCopyingThread() {
        return new ContinuousWork();
    }

    private class ContinuousWork
    extends AbstractTransformPolicy.TransformerWork {
        private ContinuousWork() {
        }

        @Override
        protected void execute() throws Exception {
            TransformContinuouslyPolicy.this.getTransformer().initialize(TransformContinuouslyPolicy.this.getInputStream().getOut());
            boolean finishWriting = false;
            while (!finishWriting) {
                TransformContinuouslyPolicy.this.getBytesRequested().addAndGet(TransformContinuouslyPolicy.this.chunkSize);
                finishWriting = TransformContinuouslyPolicy.this.getTransformer().write(TransformContinuouslyPolicy.this.getInputStream().getOut(), TransformContinuouslyPolicy.this.getBytesRequested());
            }
        }
    }
}

