/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.tokenmanager;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.module.oauth2.internal.authorizationcode.state.ConfigOAuthContext;
import org.mule.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.mule.util.store.MuleObjectStoreManager;

public class TokenManagerConfig
implements Initialisable,
MuleContextAware {
    public static AtomicInteger defaultTokenManagerConfigIndex = new AtomicInteger(0);
    private String name;
    private ListableObjectStore objectStore;
    private ConfigOAuthContext configOAuthContext;
    private MuleContext muleContext;
    private boolean initialised;

    public void setObjectStore(ListableObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.initialised) {
            return;
        }
        if (this.objectStore == null) {
            this.objectStore = (ListableObjectStore)((MuleObjectStoreManager)this.muleContext.getObjectStoreManager()).getUserObjectStore("token-manager-store-" + this.name, true);
        }
        this.configOAuthContext = new ConfigOAuthContext(this.muleContext.getLockFactory(), (ListableObjectStore<ResourceOwnerOAuthContext>)this.objectStore, this.name);
        this.initialised = true;
    }

    public static TokenManagerConfig createDefault(MuleContext context) throws InitialisationException {
        TokenManagerConfig tokenManagerConfig = new TokenManagerConfig();
        String tokenManagerConfigName = "default-token-manager-config-" + defaultTokenManagerConfigIndex.getAndIncrement();
        tokenManagerConfig.setName(tokenManagerConfigName);
        try {
            context.getRegistry().registerObject(tokenManagerConfigName, (Object)tokenManagerConfig);
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)tokenManagerConfig);
        }
        return tokenManagerConfig;
    }

    public ConfigOAuthContext getConfigOAuthContext() {
        return this.configOAuthContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object processOauthContextFunctionACall(Object[] params) {
        if (params.length > 1) {
            throw new IllegalArgumentException(String.format("oauthContext for config type %s does not accepts more than two arguments", "authorization-code"));
        }
        String resourceOwnerId = "default";
        if (params.length == 1) {
            resourceOwnerId = (String)params[0];
        }
        return this.getConfigOAuthContext().getContextForResourceOwner(resourceOwnerId);
    }
}

