/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.authorizationcode;

import java.util.HashMap;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.oauth2.internal.StateDecoder;
import org.mule.module.oauth2.internal.TokenResponseProcessor;
import org.mule.module.oauth2.internal.authorizationcode.AbstractAuthorizationCodeTokenRequestHandler;
import org.mule.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;
import org.mule.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.springframework.util.StringUtils;

public class AutoAuthorizationCodeTokenRequestHandler
extends AbstractAuthorizationCodeTokenRequestHandler {
    public static final String STATUS_CODE_FLOW_VAR_NAME = "statusCode";
    public static final String OK_STATUS_CODE = "200";
    public static final String REDIRECT_STATUS_CODE = "302";
    private TokenResponseConfiguration tokenResponseConfiguration = new TokenResponseConfiguration();

    public void setTokenResponseConfiguration(TokenResponseConfiguration tokenResponseConfiguration) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
    }

    @Override
    public void init() throws MuleException {
        this.createListenerForRedirectUrl();
    }

    @Override
    protected MessageProcessor createRedirectUrlProcessor() {
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                Map queryParams = (Map)event.getMessage().getInboundProperty("http.query.params");
                String authorizationCode = (String)queryParams.get("code");
                String state = (String)queryParams.get("state");
                event.setFlowVariable(AutoAuthorizationCodeTokenRequestHandler.STATUS_CODE_FLOW_VAR_NAME, (Object)AutoAuthorizationCodeTokenRequestHandler.OK_STATUS_CODE);
                if (authorizationCode == null) {
                    event.getMessage().setPayload((Object)("Failure retrieving access token.\n OAuth Server uri from callback: " + event.getMessage().getInboundProperty("http.request.uri")));
                } else {
                    AutoAuthorizationCodeTokenRequestHandler.this.setMapPayloadWithTokenRequestParameters(event, authorizationCode);
                    MuleEvent tokenUrlResposne = AutoAuthorizationCodeTokenRequestHandler.this.invokeTokenUrl(event);
                    AutoAuthorizationCodeTokenRequestHandler.this.decodeStateAndUpdateOAuthUserState(tokenUrlResposne, state);
                    event.getMessage().setPayload((Object)"Successfully retrieved access token!");
                }
                StateDecoder stateDecoder = new StateDecoder(state);
                String onCompleteRedirectToValue = stateDecoder.decodeOnCompleteRedirectTo();
                if (!StringUtils.isEmpty((Object)onCompleteRedirectToValue)) {
                    event.setFlowVariable(AutoAuthorizationCodeTokenRequestHandler.STATUS_CODE_FLOW_VAR_NAME, (Object)AutoAuthorizationCodeTokenRequestHandler.REDIRECT_STATUS_CODE);
                    event.getMessage().setOutboundProperty("Location", (Object)onCompleteRedirectToValue);
                }
                return event;
            }
        };
    }

    private void setMapPayloadWithTokenRequestParameters(MuleEvent event, String authorizationCode) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("code", authorizationCode);
        formData.put("client_id", this.getOauthConfig().getClientId());
        formData.put("client_secret", this.getOauthConfig().getClientSecret());
        formData.put("grant_type", "authorization_code");
        formData.put("redirect_uri", this.getOauthConfig().getRedirectionUrl());
        event.getMessage().setPayload(formData);
    }

    private void setMapPayloadWithRefreshTokenRequestParameters(MuleEvent event, String refreshToken) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("refresh_token", refreshToken);
        formData.put("client_id", this.getOauthConfig().getClientId());
        formData.put("client_secret", this.getOauthConfig().getClientSecret());
        formData.put("grant_type", "refresh_token");
        formData.put("redirect_uri", this.getOauthConfig().getRedirectionUrl());
        event.getMessage().setPayload(formData);
    }

    private void decodeStateAndUpdateOAuthUserState(MuleEvent tokenUrlResponse, String originalState) throws RegistrationException {
        StateDecoder stateDecoder = new StateDecoder(originalState);
        String decodedState = stateDecoder.decodeOriginalState();
        String encodedResourceOwnerId = stateDecoder.decodeResourceOwnerId();
        String resourceOwnerId = encodedResourceOwnerId == null ? "default" : encodedResourceOwnerId;
        ResourceOwnerOAuthContext stateForUser = this.getOauthConfig().getUserOAuthContext().getContextForResourceOwner(resourceOwnerId);
        this.processTokenUrlResponse(tokenUrlResponse, decodedState, stateForUser);
        this.getOauthConfig().getUserOAuthContext().updateResourceOwnerOAuthContext(stateForUser);
    }

    private void processTokenUrlResponse(MuleEvent tokenUrlResponse, String decodedState, ResourceOwnerOAuthContext stateForUser) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Update OAuth Context for resourceOwnerId %s", (Object)stateForUser.getResourceOwnerId());
        }
        TokenResponseProcessor tokenResponseProcessor = TokenResponseProcessor.createAuthorizationCodeProcessor(this.tokenResponseConfiguration, this.getMuleContext().getExpressionManager());
        tokenResponseProcessor.process(tokenUrlResponse);
        stateForUser.setAccessToken(tokenResponseProcessor.getAccessToken());
        stateForUser.setRefreshToken(tokenResponseProcessor.getRefreshToken());
        stateForUser.setExpiresIn(tokenResponseProcessor.getExpiresIn());
        if (decodedState != null) {
            stateForUser.setState(decodedState);
        }
        Map<String, Object> customResponseParameters = tokenResponseProcessor.getCustomResponseParameters();
        for (String paramName : customResponseParameters.keySet()) {
            Object paramValue = customResponseParameters.get(paramName);
            if (paramValue == null) continue;
            stateForUser.getTokenResponseParameters().put(paramName, paramValue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New OAuth State for resourceOwnerId %s is: accessToken(%s), refreshToken(%s), expiresIn(%s), state(%s)", new Object[]{stateForUser.getResourceOwnerId(), stateForUser.getAccessToken(), stateForUser.getRefreshToken(), stateForUser.getExpiresIn(), stateForUser.getState()});
        }
    }

    @Override
    public void doRefreshToken(MuleEvent currentEvent, ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        try {
            MuleEvent muleEvent = DefaultMuleEvent.copy((MuleEvent)currentEvent);
            muleEvent.getMessage().clearProperties(PropertyScope.OUTBOUND);
            String userRefreshToken = resourceOwnerOAuthContext.getRefreshToken();
            if (userRefreshToken == null) {
                throw new DefaultMuleException(CoreMessages.createStaticMessage((String)"The user with user id %s has no refresh token in his OAuth state so we can't execute the refresh token call", (Object[])new Object[]{resourceOwnerOAuthContext.getResourceOwnerId()}));
            }
            this.setMapPayloadWithRefreshTokenRequestParameters(muleEvent, userRefreshToken);
            MuleEvent refreshTokenResponse = this.invokeTokenUrl(muleEvent);
            this.processTokenUrlResponse(refreshTokenResponse, null, resourceOwnerOAuthContext);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

