/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.management.stats.ServiceStatistics;
import org.mule.model.seda.SedaService;
import org.mule.module.management.mbean.FlowConstructService;
import org.mule.module.management.mbean.ServiceServiceMBean;
import org.mule.module.management.mbean.ServiceStats;
import org.mule.module.management.mbean.ServiceStatsMBean;
import org.mule.service.AbstractService;

public class ServiceService
extends FlowConstructService
implements ServiceServiceMBean,
MBeanRegistration,
ServiceStatsMBean {
    private static Log LOGGER = LogFactory.getLog(ServiceService.class);
    private ServiceStatistics statistics = this.getComponent().getStatistics();

    public ServiceService(String name, MuleContext muleContext) {
        super("Service", name, muleContext);
        ((FlowConstructService)this).statistics = this.statistics;
    }

    public int getQueueSize() {
        AbstractService c = this.getComponent();
        if (c instanceof SedaService) {
            return (int)c.getStatistics().getQueuedEvents();
        }
        return -1;
    }

    public void pause() throws MuleException {
        this.getComponent().pause();
    }

    public void resume() throws MuleException {
        this.getComponent().resume();
    }

    public boolean isPaused() {
        return this.getComponent().isPaused();
    }

    public boolean isStopped() {
        return this.getComponent().isStopped();
    }

    public void stop() throws MuleException {
        this.getComponent().stop();
    }

    public void forceStop() throws MuleException {
        this.getComponent().forceStop();
    }

    public boolean isStopping() {
        return this.getComponent().isStopping();
    }

    public void dispose() throws MuleException {
        this.getComponent().dispose();
    }

    public void start() throws MuleException {
        this.getComponent().start();
    }

    public ObjectName getStatistics() {
        return this.statsName;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return super.preRegister(server, name);
    }

    public void postRegister(Boolean registrationDone) {
        try {
            if (this.getComponent().getStatistics() != null) {
                this.statsName = new ObjectName(this.objectName.getDomain() + ":type=org.mule.Statistics,service=" + this.getName());
                if (this.server.isRegistered(this.statsName)) {
                    this.server.unregisterMBean(this.statsName);
                }
                this.server.registerMBean(new ServiceStats(this.getComponent().getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering the MBean", (Throwable)e);
        }
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    private AbstractService getComponent() {
        return (AbstractService)this.muleContext.getRegistry().lookupService(this.getName());
    }

    public void clearStatistics() {
        this.statistics.clear();
    }

    public long getAsyncEventsReceived() {
        return this.statistics.getAsyncEventsReceived();
    }

    public long getSyncEventsReceived() {
        return this.statistics.getSyncEventsReceived();
    }

    public long getTotalEventsReceived() {
        return this.statistics.getTotalEventsReceived();
    }

    public long getAsyncEventsSent() {
        return this.statistics.getAsyncEventsSent();
    }

    public long getAverageExecutionTime() {
        return this.statistics.getAverageExecutionTime();
    }

    public long getAverageQueueSize() {
        return this.statistics.getAverageQueueSize();
    }

    public long getExecutedEvents() {
        return this.statistics.getExecutedEvents();
    }

    public long getMaxExecutionTime() {
        return this.statistics.getMaxExecutionTime();
    }

    public long getMaxQueueSize() {
        return this.statistics.getMaxQueueSize();
    }

    public long getMinExecutionTime() {
        return this.statistics.getMinExecutionTime();
    }

    public long getQueuedEvents() {
        return this.statistics.getQueuedEvents();
    }

    public long getReplyToEventsSent() {
        return this.statistics.getReplyToEventsSent();
    }

    public long getSyncEventsSent() {
        return this.statistics.getSyncEventsSent();
    }

    public long getTotalEventsSent() {
        return this.statistics.getTotalEventsSent();
    }

    public long getTotalExecutionTime() {
        return this.statistics.getTotalExecutionTime();
    }
}

