/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.jmx.HierarchyDynamicMBean;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;

public class Log4jAgent
extends AbstractAgent {
    private MBeanServer mBeanServer;
    public static final String JMX_OBJECT_NAME = "log4j:type=Hierarchy";
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();

    public Log4jAgent() {
        super("jmx-log4j");
    }

    public void initialise() throws InitialisationException {
        try {
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName objectName = this.jmxSupport.getObjectName(JMX_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(new HierarchyDynamicMBean(), objectName);
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToStart((String)"JMX Agent"), (Throwable)e, (Initialisable)this);
        }
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer.isRegistered(this.jmxSupport.getObjectName(JMX_OBJECT_NAME))) {
            Set<ObjectInstance> log4jMBeans = this.mBeanServer.queryMBeans(this.jmxSupport.getObjectName("log4j*:*"), null);
            for (ObjectInstance objectInstance : log4jMBeans) {
                ObjectName theName = objectInstance.getObjectName();
                this.mBeanServer.unregisterMBean(theName);
            }
        }
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
        try {
            this.unregisterMBeansIfNecessary();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }
}

