/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.config.MuleManifest;
import org.mule.management.mbeans.MuleServiceMBean;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;

public class MuleService
implements MuleServiceMBean {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String version;
    private String vendor;
    private String jdk;
    private String host;
    private String ip;
    private String os;
    private String buildDate;
    private String copyright = "Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com";
    private String license;
    private UMOManagementContext managementContext;

    public MuleService(UMOManagementContext managementContext) {
        this.managementContext = managementContext;
        String patch = System.getProperty("sun.os.patch.level", null);
        this.jdk = System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")";
        this.os = System.getProperty("os.name");
        if (patch != null && !"unknown".equalsIgnoreCase(patch)) {
            this.os = this.os + " - " + patch;
        }
        this.os = this.os + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")";
        this.buildDate = MuleManifest.getBuildNumber();
        try {
            InetAddress iad = InetAddress.getLocalHost();
            this.host = iad.getCanonicalHostName();
            this.ip = iad.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public boolean isInitialised() {
        return this.managementContext != null && this.managementContext.isInitialised();
    }

    public boolean isStopped() {
        return this.managementContext != null && !this.managementContext.isStarted();
    }

    public Date getStartTime() {
        if (!this.isStopped()) {
            return new Date(this.managementContext.getStartDate());
        }
        return null;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = MuleManifest.getProductVersion();
            if (this.version == null) {
                this.version = "Mule Version Info Not Set";
            }
        }
        return this.version;
    }

    public String getVendor() {
        if (this.vendor == null) {
            this.vendor = MuleManifest.getVendorName();
            if (this.vendor == null) {
                this.vendor = "Mule Vendor Info Not Set";
            }
        }
        return this.vendor;
    }

    public void start() throws UMOException {
        this.managementContext.start();
    }

    public void stop() throws UMOException {
        this.managementContext.stop();
    }

    public void dispose() throws UMOException {
        this.managementContext.dispose();
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public String getServerId() {
        return this.managementContext.getId();
    }

    public String getHostname() {
        return this.host;
    }

    public String getHostIp() {
        return this.ip;
    }

    public String getOsVersion() {
        return this.os;
    }

    public String getJdkVersion() {
        return this.jdk;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getLicense() {
        if (this.license == null) {
            try {
                this.license = IOUtils.getResourceAsString((String)"MULE_LICENSE.txt", this.getClass());
                this.license = StringMessageUtils.getBoilerPlate((String)this.license, (char)' ', (int)80);
            }
            catch (IOException e) {
                this.logger.warn((Object)"Failed to load LICENSE.txt", (Throwable)e);
            }
            if (this.license == null) {
                this.license = "Failed to load license";
            }
        }
        return this.license;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getInstanceId() {
        return this.managementContext.getId();
    }

    public String getConfigBuilderClassName() {
        return MuleServer.getConfigBuilderClassName();
    }
}

