/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import java.util.HashMap;
import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.management.agents.JmxAgent;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JmxAgentDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    public static final String CONNECTOR_SERVER = "connector-server";

    protected Class getBeanClass(Element element) {
        return JmxAgent.class;
    }

    protected void postProcess(BeanDefinitionBuilder definition, Element element) {
        super.postProcess(definition, element);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!CONNECTOR_SERVER.equals(node.getLocalName())) continue;
            definition.getBeanDefinition().getPropertyValues().addPropertyValue("connectorServerUrl", (Object)((Element)node).getAttribute("url"));
            String rebind = ((Element)node).getAttribute("rebind");
            if (StringUtils.isEmpty((String)rebind)) continue;
            HashMap<String, String> csProps = new HashMap<String, String>();
            csProps.put("jmx.remote.jndi.rebind", rebind);
            definition.getBeanDefinition().getPropertyValues().addPropertyValue("connectorServerProperties", csProps);
        }
    }
}

