/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.logging;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

public class LoggerReferenceHandler {
    protected Logger logger = Logger.getLogger(this.getClass());

    public LoggerReferenceHandler(final String threadName, final ReferenceQueue<ClassLoader> referenceQueue, final Map<PhantomReference<ClassLoader>, Integer> references, final Map<Integer, ?> loggerRepository) {
        Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName(threadName);
                return thread;
            }
        }).submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Reference reference = referenceQueue.remove();
                        LoggerReferenceHandler.this.logger.debug((Object)"Cleaning up the logging hierarchy");
                        Integer classLoaderHash = (Integer)references.get(reference);
                        loggerRepository.remove(classLoaderHash);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (RuntimeException rex) {
                        LoggerReferenceHandler.this.logger.error((Object)"Zombies detected, run for your life", (Throwable)rex);
                    }
                }
            }
        });
    }
}

