/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.domain;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.MuleSharedDomainClassLoader;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.ShutdownListener;
import org.mule.module.launcher.descriptor.DomainDescriptor;
import org.mule.module.launcher.descriptor.EmptyDomainDescriptor;
import org.mule.module.launcher.domain.DomainClassLoaderRepository;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.Preconditions;

public class MuleDomainClassLoaderRepository
implements DomainClassLoaderRepository {
    private Map<String, ArtifactClassLoader> domainArtifactClassLoaders = new HashMap<String, ArtifactClassLoader>();
    private ArtifactClassLoader defaultDomainArtifactClassLoader;

    @Override
    public synchronized ArtifactClassLoader getDomainClassLoader(DomainDescriptor descriptor) {
        String domain = descriptor.getName();
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (String)"Domain name cannot be null");
        if (domain.equals("default")) {
            return this.getDefaultDomainClassLoader();
        }
        if (this.domainArtifactClassLoaders.containsKey(domain)) {
            return this.domainArtifactClassLoaders.get(domain);
        }
        this.validateDomain(domain);
        ArtifactClassLoader classLoader = new MuleSharedDomainClassLoader(domain, this.getClass().getClassLoader(), descriptor.getLoaderOverride());
        classLoader = this.createClassLoaderUnregisterWrapper(classLoader);
        this.domainArtifactClassLoaders.put(domain, classLoader);
        return classLoader;
    }

    @Override
    public synchronized ArtifactClassLoader getDomainClassLoader(String domain) {
        return this.getDomainClassLoader(new EmptyDomainDescriptor(domain));
    }

    @Override
    public ArtifactClassLoader getDefaultDomainClassLoader() {
        if (this.defaultDomainArtifactClassLoader != null) {
            return this.defaultDomainArtifactClassLoader;
        }
        MuleSharedDomainClassLoader classLoader = new MuleSharedDomainClassLoader("default", this.getClass().getClassLoader());
        this.defaultDomainArtifactClassLoader = this.createClassLoaderUnregisterWrapper(classLoader);
        return this.defaultDomainArtifactClassLoader;
    }

    private void validateDomain(String domain) {
        File domainFolder = new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), domain);
        if (!domainFolder.exists() || !domainFolder.isDirectory()) {
            throw new DeploymentException(CoreMessages.createStaticMessage((String)String.format("Domain %s does not exists", domain)));
        }
    }

    private ArtifactClassLoader createClassLoaderUnregisterWrapper(final ArtifactClassLoader classLoader) {
        return new ArtifactClassLoader(){

            @Override
            public String getArtifactName() {
                return classLoader.getArtifactName();
            }

            @Override
            public URL findResource(String resource) {
                return classLoader.findResource(resource);
            }

            @Override
            public URL findLocalResource(String resource) {
                return classLoader.findLocalResource(resource);
            }

            @Override
            public ClassLoader getClassLoader() {
                return classLoader.getClassLoader();
            }

            @Override
            public void dispose() {
                MuleDomainClassLoaderRepository.this.domainArtifactClassLoaders.remove(classLoader.getArtifactName());
                classLoader.dispose();
            }

            @Override
            public void addShutdownListener(ShutdownListener listener) {
                classLoader.addShutdownListener(listener);
            }
        };
    }
}

