/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.mule.module.launcher.descriptor.DomainDescriptor;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class DomainDescriptorParser {
    public DomainDescriptor parse(File descriptor) throws IOException {
        Properties properties = PropertiesUtils.loadProperties((InputStream)new FileInputStream(descriptor));
        DomainDescriptor domainDescriptor = new DomainDescriptor();
        domainDescriptor.setRedeploymentEnabled(BooleanUtils.toBoolean((String)properties.getProperty("redeployment.enabled", Boolean.TRUE.toString())));
        String overrideString = properties.getProperty("loader.override");
        if (StringUtils.isNotBlank((String)overrideString)) {
            HashSet<String> values = new HashSet<String>();
            String[] overrides = overrideString.split(",");
            Collections.addAll(values, overrides);
            domainDescriptor.setLoaderOverride(values);
        }
        return domainDescriptor;
    }
}

