/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.util.Properties;
import org.mule.DefaultMuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.PropertiesMuleConfigurationFactory;
import org.mule.config.bootstrap.ArtifactType;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.util.StringUtils;
import org.mule.work.MuleWorkManager;

public class ApplicationMuleContextBuilder
extends DefaultMuleContextBuilder {
    protected ApplicationDescriptor desc;

    public ApplicationMuleContextBuilder(ApplicationDescriptor desc, Properties deploymentProperties) {
        this.desc = desc;
        this.setDeploymentProperties(deploymentProperties);
    }

    public ApplicationMuleContextBuilder(ApplicationDescriptor desc) {
        this.desc = desc;
    }

    protected DefaultMuleContext createDefaultMuleContext() {
        DefaultMuleContext muleContext = super.createDefaultMuleContext();
        muleContext.setArtifactType(ArtifactType.APP);
        return muleContext;
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration(true);
        PropertiesMuleConfigurationFactory.initializeFromProperties((MuleConfiguration)configuration, this.desc.getAppProperties());
        configuration.setId(this.desc.getName());
        String encoding = this.desc.getEncoding();
        if (StringUtils.isNotBlank((String)encoding)) {
            configuration.setDefaultEncoding(encoding);
        }
        return configuration;
    }

    protected MuleWorkManager createWorkManager() {
        String threadName = String.format("[%s].Mule", this.desc.getName());
        return new MuleWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, threadName, this.getMuleConfiguration().getShutdownTimeout());
    }
}

