/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public class PluginClasspath {
    private URL runtimeClassesDir;
    private URL[] runtimeLibs = new URL[0];

    protected PluginClasspath() {
    }

    public static PluginClasspath from(File pluginDir) {
        if (!pluginDir.exists()) {
            throw new IllegalArgumentException("Can't read from the temporary plugin directory: " + pluginDir);
        }
        PluginClasspath cp = new PluginClasspath();
        try {
            cp.setRuntimeClassesDir(new File(pluginDir, "classes").toURI().toURL());
            File libDir = new File(pluginDir, "lib");
            if (libDir.exists()) {
                File[] jars = libDir.listFiles((FilenameFilter)new SuffixFileFilter(".jar"));
                URL[] urls = new URL[jars.length];
                for (int i = 0; i < jars.length; ++i) {
                    urls[i] = jars[i].toURI().toURL();
                }
                cp.setRuntimeLibs(urls);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to getDomainClassLoader plugin classpath " + pluginDir);
        }
        return cp;
    }

    public URL[] getRuntimeLibs() {
        return this.runtimeLibs;
    }

    public URL getRuntimeClassesDir() {
        return this.runtimeClassesDir;
    }

    public URL[] toURLs() {
        URL[] merged = new URL[this.runtimeLibs.length + 1];
        merged[0] = this.runtimeClassesDir;
        System.arraycopy(this.runtimeLibs, 0, merged, 1, this.runtimeLibs.length);
        return merged;
    }

    protected void setRuntimeClassesDir(URL runtimeClassesDir) {
        this.runtimeClassesDir = runtimeClassesDir;
    }

    protected void setRuntimeLibs(URL[] runtimeLibs) {
        this.runtimeLibs = runtimeLibs;
    }
}

