/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j2;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.DefaultAppBloodhound;
import org.mule.module.launcher.DirectoryResourceLocator;
import org.mule.module.launcher.LocalResourceLocator;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.ShutdownListener;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.module.launcher.log4j2.MuleLoggerContext;
import org.mule.module.reboot.MuleContainerBootstrapUtils;

public class MuleLoggerContextFactory {
    public LoggerContext build(final ClassLoader classLoader, final ArtifactAwareContextSelector selector) {
        NewContextParameters parameters = this.resolveContextParameters(classLoader);
        if (parameters == null) {
            return this.getDefaultContext(selector);
        }
        MuleLoggerContext loggerContext = new MuleLoggerContext(parameters.contextName, parameters.loggerConfigFile, classLoader, selector, this.isStandalone());
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)((Object)classLoader);
            artifactClassLoader.addShutdownListener(new ShutdownListener(){

                @Override
                public void execute() {
                    selector.destroyLoggersFor(ArtifactAwareContextSelector.resolveLoggerContextClassLoader(classLoader));
                }
            });
        }
        return loggerContext;
    }

    private NewContextParameters resolveContextParameters(ClassLoader classLoader) {
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)((Object)classLoader);
            return new NewContextParameters(this.getArtifactLoggingConfig(artifactClassLoader), artifactClassLoader.getArtifactName());
        }
        if (MuleContainerBootstrapUtils.getMuleConfDir() != null) {
            return new NewContextParameters(this.getLogConfig(new DirectoryResourceLocator(MuleContainerBootstrapUtils.getMuleConfDir().getAbsolutePath())), classLoader.toString());
        }
        return null;
    }

    private URI getArtifactLoggingConfig(ArtifactClassLoader muleCL) {
        URI appLogConfig;
        try {
            ApplicationDescriptor appDescriptor = this.fetchApplicationDescriptor(muleCL);
            if (appDescriptor.getLogConfigFile() == null) {
                appLogConfig = this.getLogConfig(muleCL);
            } else if (!appDescriptor.getLogConfigFile().exists()) {
                ArtifactAwareContextSelector.logger.warn("Configured 'log.configFile' in app descriptor points to a non-existant file. Using default configuration.");
                appLogConfig = this.getLogConfig(muleCL);
            } else {
                appLogConfig = appDescriptor.getLogConfigFile().toURI();
            }
        }
        catch (Exception e) {
            ArtifactAwareContextSelector.logger.warn("{} while looking for 'log.configFile' entry in app descriptor: {}. Using default configuration.", (Object)e.getClass().getName(), (Object)e.getMessage());
            appLogConfig = this.getLogConfig(muleCL);
        }
        if (appLogConfig != null && ArtifactAwareContextSelector.logger.isInfoEnabled()) {
            ArtifactAwareContextSelector.logger.info("Found logging config for application '{}' at '{}'", (Object)muleCL.getArtifactName(), (Object)appLogConfig);
        }
        return appLogConfig;
    }

    private LoggerContext getDefaultContext(ArtifactAwareContextSelector selector) {
        return new MuleLoggerContext("Default", selector, this.isStandalone());
    }

    private boolean isStandalone() {
        return MuleContainerBootstrapUtils.getMuleConfDir() != null;
    }

    private URI getLogConfig(LocalResourceLocator localResourceLocator) {
        URL appLogConfig = localResourceLocator.findLocalResource("log4j2-test.xml");
        if (appLogConfig == null) {
            appLogConfig = localResourceLocator.findLocalResource("log4j2.xml");
        }
        if (appLogConfig == null) {
            File defaultConfigFile = new File(MuleContainerBootstrapUtils.getMuleHome(), "conf");
            defaultConfigFile = new File(defaultConfigFile, "log4j2.xml");
            try {
                appLogConfig = defaultConfigFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not locate log config in MULE_HOME"), (Throwable)e);
            }
        }
        try {
            return appLogConfig.toURI();
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not read log file " + appLogConfig)), (Throwable)e);
        }
    }

    public ApplicationDescriptor fetchApplicationDescriptor(ArtifactClassLoader muleCL) throws IOException {
        return new DefaultAppBloodhound().fetch(muleCL.getArtifactName());
    }

    private class NewContextParameters {
        private final URI loggerConfigFile;
        private final String contextName;

        private NewContextParameters(URI loggerConfigFile, String contextName) {
            this.loggerConfigFile = loggerConfigFile;
            this.contextName = contextName;
        }
    }
}

