/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.module.launcher.MuleFoldersUtil;
import org.mule.util.FileUtils;

public class DeploymentPropertiesUtils {
    private static final String DEPLOYMENT_PROPERTIES_FILE_NAME = "deployment.properties";
    private static final String DEPLOYTMENT_PROPERTIES_DIRECTORY = "deployment-properties";

    public static Properties resolveDeploymentProperties(String artifactName, Optional<Properties> deploymentProperties) throws IOException {
        File file = new File(MuleFoldersUtil.getExecutionFolder(), artifactName);
        String workingDirectory = file.getAbsolutePath();
        String deploymentPropertiesPath = workingDirectory + File.separator + DEPLOYTMENT_PROPERTIES_DIRECTORY;
        if (!deploymentProperties.isPresent()) {
            return DeploymentPropertiesUtils.getDeploymentProperties(deploymentPropertiesPath);
        }
        DeploymentPropertiesUtils.initDeploymentPropertiesDirectory(deploymentPropertiesPath);
        DeploymentPropertiesUtils.persistDeploymentPropertiesFile(deploymentPropertiesPath, (Properties)deploymentProperties.get());
        return (Properties)deploymentProperties.get();
    }

    private static Properties getDeploymentProperties(String deploymentPropertiesPath) throws IOException {
        File configFile = new File(deploymentPropertiesPath + File.separator + DEPLOYMENT_PROPERTIES_FILE_NAME);
        Properties props = new Properties();
        if (!configFile.exists()) {
            return props;
        }
        FileReader reader = new FileReader(configFile);
        props.load(reader);
        return props;
    }

    private static void initDeploymentPropertiesDirectory(String deploymentPropertiesPath) {
        File deploymentPropertiesDirectory = FileUtils.newFile((String)deploymentPropertiesPath);
        if (!deploymentPropertiesDirectory.exists()) {
            DeploymentPropertiesUtils.createDeploymentPropertiesDirectory(deploymentPropertiesDirectory);
        }
    }

    private static synchronized void createDeploymentPropertiesDirectory(File deploymentPropertiesDirectory) {
        if (!deploymentPropertiesDirectory.exists() && !deploymentPropertiesDirectory.mkdirs()) {
            Message message = CoreMessages.failedToCreate((String)("deployment properties directory " + deploymentPropertiesDirectory.getAbsolutePath()));
            throw new MuleRuntimeException(message);
        }
    }

    private static void persistDeploymentPropertiesFile(String deploymentPropertiesPath, Properties deploymentProperties) throws IOException {
        File deploymentPropertiesFile = new File(deploymentPropertiesPath, DEPLOYMENT_PROPERTIES_FILE_NAME);
        FileWriter fileWriter = new FileWriter(deploymentPropertiesFile.getAbsolutePath(), false);
        deploymentProperties.store(fileWriter, "deployment properties");
        fileWriter.close();
    }
}

