/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.artifact;

import java.lang.management.ManagementFactory;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.module.launcher.artifact.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceReleaser
implements ResourceReleaser {
    public static final String DIAGNOSABILITY_BEAN_NAME = "diagnosability";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void release() {
        this.deregisterJdbcDrivers();
    }

    private void deregisterJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (this.isDriverLoadedByThisClassLoader(driver)) {
                this.doDeregisterDriver(driver);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug(String.format("Skipping deregister driver %s. It wasn't loaded by the classloader of the artifact being released.", driver.getClass()));
        }
    }

    private boolean isDriverLoadedByThisClassLoader(Driver driver) {
        for (ClassLoader driverClassLoader = driver.getClass().getClassLoader(); driverClassLoader != null; driverClassLoader = driverClassLoader.getParent()) {
            if (!driverClassLoader.equals(this.getClass().getClassLoader())) continue;
            return true;
        }
        return false;
    }

    private void doDeregisterDriver(Driver driver) {
        try {
            this.logger.debug("Deregistering driver: {}", driver.getClass());
            DriverManager.deregisterDriver(driver);
            if (this.isOracleDriver(driver)) {
                this.deregisterOracleDiagnosabilityMBean();
            }
        }
        catch (Exception e) {
            this.logger.warn(String.format("Can not deregister driver %s. This can cause a memory leak.", driver.getClass()), (Throwable)e);
        }
    }

    private boolean isOracleDriver(Driver driver) {
        return "oracle.jdbc.OracleDriver".equals(driver.getClass().getName());
    }

    private void deregisterOracleDiagnosabilityMBean() {
        ClassLoader cl = this.getClass().getClassLoader();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put("type", DIAGNOSABILITY_BEAN_NAME);
        keys.put("name", cl.getClass().getName() + "@" + Integer.toHexString(cl.hashCode()).toLowerCase());
        try {
            mBeanServer.unregisterMBean(new ObjectName("com.oracle.jdbc", keys));
        }
        catch (InstanceNotFoundException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("No Oracle's '%s' MBean found.", DIAGNOSABILITY_BEAN_NAME));
            }
        }
        catch (Throwable e) {
            this.logger.warn("Unable to unregister Oracle's mbeans");
        }
    }
}

