/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.config.ExceptionHelper;
import org.mule.config.StartupContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.MuleContainerStartupSplashScreen;
import org.mule.module.launcher.MuleDeploymentService;
import org.mule.module.launcher.MuleFoldersUtil;
import org.mule.module.launcher.MulePluginClassLoaderManager;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.coreextension.DefaultMuleCoreExtensionManager;
import org.mule.module.launcher.coreextension.MuleCoreExtensionManager;
import org.mule.module.launcher.log4j2.MuleLog4jContextFactory;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

public class MuleContainer {
    public static final String[][] CLI_OPTIONS = new String[][]{{"builder", "true", "Configuration Builder Type"}, {"config", "true", "Configuration File"}, {"idle", "false", "Whether to run in idle (unconfigured) mode"}, {"main", "true", "Main Class"}, {"mode", "true", "Run Mode"}, {"props", "true", "Startup Properties"}, {"production", "false", "Production Mode"}, {"debug", "false", "Configure Mule for JPDA remote debugging."}, {"app", "true", "Application to start"}};
    private static final Log logger;
    private static String startupPropertiesFile;
    private static MuleShutdownHook muleShutdownHook;
    protected final DeploymentService deploymentService;
    private final MuleCoreExtensionManager coreExtensionManager;
    private final PluginClassLoaderManager pluginClassLoaderManager = new MulePluginClassLoaderManager();

    public static void main(String[] args) throws Exception {
        MuleContainer container = new MuleContainer(args);
        container.start(true);
    }

    public MuleContainer(String[] args) {
        this.deploymentService = new MuleDeploymentService(this.pluginClassLoaderManager);
        this.coreExtensionManager = new DefaultMuleCoreExtensionManager();
        this.init(args);
    }

    public MuleContainer(DeploymentService deploymentService, MuleCoreExtensionManager coreExtensionManager) {
        this(new String[0], deploymentService, coreExtensionManager);
    }

    public MuleContainer(String[] args, DeploymentService deploymentService, MuleCoreExtensionManager coreExtensionManager) throws IllegalArgumentException {
        this.deploymentService = deploymentService;
        this.coreExtensionManager = coreExtensionManager;
        this.init(args);
    }

    protected void init(String[] args) throws IllegalArgumentException {
        Map commandlineOptions;
        try {
            commandlineOptions = SystemUtils.getCommandLineOptions((String[])args, (String[][])CLI_OPTIONS);
        }
        catch (DefaultMuleException me) {
            throw new IllegalArgumentException(me.toString());
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        String propertiesFile = (String)commandlineOptions.get("props");
        if (propertiesFile != null) {
            MuleContainer.setStartupPropertiesFile(propertiesFile);
        }
        StartupContext.get().setStartupOptions(commandlineOptions);
    }

    private void createExecutionMuleFolder() {
        File executionFolder = MuleFoldersUtil.getExecutionFolder();
        if (!executionFolder.exists() && !executionFolder.mkdirs()) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("Could not create folder %s, validate that the process has permissions over that directory", executionFolder.getAbsolutePath())));
        }
    }

    public void start(boolean registerShutdownHook) throws MuleException {
        if (registerShutdownHook) {
            this.registerShutdownHook();
        }
        this.showSplashScreen();
        try {
            this.createExecutionMuleFolder();
            this.coreExtensionManager.setDeploymentService(this.deploymentService);
            this.coreExtensionManager.setPluginClassLoaderManager(this.pluginClassLoaderManager);
            this.coreExtensionManager.initialise();
            this.coreExtensionManager.start();
            this.deploymentService.start();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    protected void showSplashScreen() {
        MuleContainerStartupSplashScreen splashScreen = new MuleContainerStartupSplashScreen();
        splashScreen.doBody();
        logger.info((Object)splashScreen.toString());
    }

    public void shutdown(Throwable e) throws MuleException {
        Message msg = CoreMessages.fatalErrorWhileRunning();
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)e);
        if (muleException != null) {
            logger.fatal((Object)muleException.getDetailedMessage());
        } else {
            logger.fatal((Object)(msg.toString() + " " + e.getMessage()), e);
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(msg.getMessage());
        Throwable root = ExceptionHelper.getRootException((Throwable)e);
        msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
        msgs.add(" ");
        msgs.add(CoreMessages.fatalErrorInShutdown().getMessage());
        String shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)80);
        logger.fatal((Object)shutdownMessage);
        this.unregisterShutdownHook();
        this.doShutdown();
    }

    public void shutdown() throws MuleException {
        logger.info((Object)"Mule container shutting down due to normal shutdown request");
        this.unregisterShutdownHook();
        this.doShutdown();
    }

    protected void doShutdown() throws MuleException {
        this.stop();
        System.exit(0);
    }

    public void stop() throws MuleException {
        this.coreExtensionManager.stop();
        if (this.deploymentService != null) {
            this.deploymentService.stop();
        }
        this.coreExtensionManager.dispose();
        if (LogManager.getFactory() instanceof MuleLog4jContextFactory) {
            ((MuleLog4jContextFactory)LogManager.getFactory()).dispose();
        }
    }

    public Log getLogger() {
        return logger;
    }

    public void registerShutdownHook() {
        if (muleShutdownHook == null) {
            muleShutdownHook = new MuleShutdownHook();
        } else {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
        Runtime.getRuntime().addShutdownHook(muleShutdownHook);
    }

    public void unregisterShutdownHook() {
        if (muleShutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
    }

    public static String getStartupPropertiesFile() {
        return startupPropertiesFile;
    }

    public static void setStartupPropertiesFile(String startupPropertiesFile) {
        MuleContainer.startupPropertiesFile = startupPropertiesFile;
    }

    static {
        startupPropertiesFile = null;
        if (System.getProperty("mule.simpleLog") == null) {
            LogManager.setFactory((LoggerContextFactory)new MuleLog4jContextFactory());
        }
        logger = LogFactory.getLog(MuleContainer.class);
    }

    private class MuleShutdownHook
    extends Thread {
        public MuleShutdownHook() {
            super("Mule.shutdown.hook");
        }

        @Override
        public void run() {
            try {
                MuleContainer.this.doShutdown();
            }
            catch (MuleException e) {
                logger.warn((Object)"Error shutting down mule container", (Throwable)e);
            }
        }
    }
}

