/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.log4j2;

import java.net.URI;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.mule.module.launcher.application.ApplicationClassLoader;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.log4j2.DispatchingLogger;
import org.mule.module.launcher.log4j2.LoggerContextConfigurer;

class MuleLoggerContext
extends LoggerContext {
    protected static final int NO_CCL_CLASSLOADER = 0;
    private final URI configFile;
    private final boolean standlone;
    private final ContextSelector contextSelector;
    private final boolean artifactClassloader;
    private final boolean applicationClassloader;
    private final String artifactName;
    private final int ownerClassLoaderHash;

    MuleLoggerContext(String name, ContextSelector contextSelector, boolean standalone) {
        this(name, null, null, contextSelector, standalone);
    }

    MuleLoggerContext(String name, URI configLocn, ClassLoader ownerClassLoader, ContextSelector contextSelector, boolean standalone) {
        super(name, null, configLocn);
        int n;
        this.configFile = configLocn;
        this.contextSelector = contextSelector;
        this.standlone = standalone;
        if (ownerClassLoader != null) {
            n = ownerClassLoader.hashCode();
        } else {
            ((Object)((Object)this)).getClass().getClassLoader();
            n = this.ownerClassLoaderHash = ClassLoader.getSystemClassLoader().hashCode();
        }
        if (ownerClassLoader instanceof ArtifactClassLoader) {
            this.artifactClassloader = true;
            this.artifactName = ((ArtifactClassLoader)((Object)ownerClassLoader)).getArtifactName();
            this.applicationClassloader = ownerClassLoader instanceof ApplicationClassLoader;
        } else {
            this.artifactClassloader = false;
            this.applicationClassloader = false;
            this.artifactName = null;
        }
    }

    public synchronized void reconfigure() {
        super.reconfigure();
        new LoggerContextConfigurer().configure(this);
    }

    public void updateLoggers(Configuration config) {
        super.updateLoggers(config);
        for (Logger logger : this.getLoggers()) {
            if (!(logger instanceof DispatchingLogger)) continue;
            ((DispatchingLogger)logger).updateConfiguration(config);
        }
    }

    protected Logger newInstance(LoggerContext ctx, final String name, MessageFactory messageFactory) {
        return new DispatchingLogger(super.newInstance(ctx, name, messageFactory), this.ownerClassLoaderHash, this, this.contextSelector, messageFactory){

            public String getName() {
                return name;
            }
        };
    }

    protected URI getConfigFile() {
        return this.configFile;
    }

    protected boolean isStandlone() {
        return this.standlone;
    }

    protected boolean isArtifactClassloader() {
        return this.artifactClassloader;
    }

    protected boolean isApplicationClassloader() {
        return this.applicationClassloader;
    }

    protected String getArtifactName() {
        return this.artifactName;
    }
}

