/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.artifact;

import java.io.File;
import java.io.IOException;
import org.mule.api.MuleContext;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.InstallException;
import org.mule.module.launcher.artifact.Artifact;
import org.mule.module.launcher.artifact.ArtifactClassLoader;

public class ArtifactWrapper<T extends Artifact>
implements Artifact {
    private T delegate;

    protected ArtifactWrapper(T artifact) throws IOException {
        this.delegate = artifact;
    }

    @Override
    public void dispose() {
        this.executeWithinArtifactClassLoader(new ArtifactAction(){

            @Override
            public void execute() {
                ArtifactWrapper.this.delegate.dispose();
            }
        });
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.delegate.getArtifactClassLoader();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.delegate.getMuleContext();
    }

    @Override
    public void init() {
        this.executeWithinArtifactClassLoader(new ArtifactAction(){

            @Override
            public void execute() {
                ArtifactWrapper.this.delegate.init();
            }
        });
    }

    @Override
    public void install() throws InstallException {
        this.executeWithinArtifactClassLoader(new ArtifactAction(){

            @Override
            public void execute() {
                ArtifactWrapper.this.delegate.install();
            }
        });
    }

    @Override
    public String getArtifactName() {
        return this.delegate.getArtifactName();
    }

    @Override
    public File[] getResourceFiles() {
        return this.delegate.getResourceFiles();
    }

    @Override
    public void start() throws DeploymentStartException {
        this.executeWithinArtifactClassLoader(new ArtifactAction(){

            @Override
            public void execute() {
                ArtifactWrapper.this.delegate.start();
            }
        });
    }

    @Override
    public void stop() {
        this.executeWithinArtifactClassLoader(new ArtifactAction(){

            @Override
            public void execute() {
                ArtifactWrapper.this.delegate.stop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithinArtifactClassLoader(ArtifactAction artifactAction) {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader artifactCl;
            if (this.getArtifactClassLoader() != null && (artifactCl = this.getArtifactClassLoader().getClassLoader()) != null) {
                Thread.currentThread().setContextClassLoader(artifactCl);
            }
            artifactAction.execute();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    public String getAppName() {
        return this.getArtifactName();
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getName(), this.delegate);
    }

    public T getDelegate() {
        return this.delegate;
    }

    private static interface ArtifactAction {
        public void execute();
    }
}

