/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.ArchiveDeployer;
import org.mule.module.launcher.ArtifactArchiveInstaller;
import org.mule.module.launcher.ArtifactDeployer;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.application.NullDeploymentListener;
import org.mule.module.launcher.artifact.Artifact;
import org.mule.module.launcher.artifact.ArtifactFactory;
import org.mule.module.launcher.util.ObservableList;
import org.mule.util.CollectionUtils;
import org.mule.util.SplashScreen;
import org.mule.util.StringUtils;

public class DefaultArchiveDeployer<T extends Artifact>
implements ArchiveDeployer<T> {
    public static final String ARTIFACT_NAME_PROPERTY = "artifactName";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    public static final String ANOTHER_DEPLOYMENT_OPERATION_IS_IN_PROGRESS = "Another deployment operation is in progress";
    public static final String INSTALL_OPERATION_HAS_BEEN_INTERRUPTED = "Install operation has been interrupted";
    private static final Log logger = LogFactory.getLog(DefaultArchiveDeployer.class);
    private final ArtifactDeployer<T> deployer;
    private final ArtifactArchiveInstaller artifactArchiveInstaller;
    private final ReentrantLock deploymentLock;
    private final Map<String, ZombieFile> artifactZombieMap = new HashMap<String, ZombieFile>();
    private final File artifactDir;
    private final ObservableList<T> artifacts;
    private ArtifactFactory<T> artifactFactory;
    private DeploymentListener deploymentListener = new NullDeploymentListener();

    public DefaultArchiveDeployer(ArtifactDeployer deployer, ArtifactFactory artifactFactory, ObservableList<T> artifacts, ReentrantLock lock) {
        this.deployer = deployer;
        this.artifactFactory = artifactFactory;
        this.artifacts = artifacts;
        this.deploymentLock = lock;
        this.artifactDir = artifactFactory.getArtifactDir();
        this.artifactArchiveInstaller = new ArtifactArchiveInstaller(this.artifactDir);
    }

    @Override
    public T deployPackagedArtifact(String zip) throws DeploymentException {
        try {
            String artifactName = StringUtils.removeEnd((String)zip, (String)ZIP_FILE_SUFFIX);
            File artifactZip = new File(this.artifactDir, zip);
            URL url = artifactZip.toURI().toURL();
            return this.deployPackagedArtifact(url, artifactName);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(CoreMessages.createStaticMessage((String)("Failed to deploy from zip: " + zip)), e);
        }
    }

    @Override
    public T deployExplodedArtifact(String artifactDir) throws DeploymentException {
        String artifactName = artifactDir;
        Collection deployedAppNames = CollectionUtils.collect(this.artifacts, (Transformer)new BeanToPropertyValueTransformer(ARTIFACT_NAME_PROPERTY));
        if (deployedAppNames.contains(artifactName) && !this.artifactZombieMap.containsKey(artifactName)) {
            return null;
        }
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        if (zombieFile != null && !zombieFile.updatedZombieApp()) {
            return null;
        }
        return this.deployExplodedApp(artifactName);
    }

    @Override
    public void undeployArtifact(String artifactId) {
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactId);
        if (zombieFile != null) {
            return;
        }
        Artifact artifact = (Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactId));
        this.undeploy(artifact);
    }

    @Override
    public File getDeploymentDirectory() {
        return this.artifactFactory.getArtifactDir();
    }

    @Override
    public T deployPackagedArtifact(URL artifactAchivedUrl) throws DeploymentException {
        try {
            T artifact;
            try {
                artifact = this.guardedInstallFrom(artifactAchivedUrl);
                this.trackArtifact(artifact);
            }
            catch (Throwable t) {
                File artifactArchive = new File(artifactAchivedUrl.toURI());
                String artifactName = StringUtils.removeEnd((String)artifactArchive.getName(), (String)ZIP_FILE_SUFFIX);
                this.logDeploymentFailure(t, artifactName);
                this.addZombieFile(artifactName, artifactArchive);
                this.deploymentListener.onDeploymentFailure(artifactName, t);
                throw t;
            }
            this.deployArtifact(artifact);
            return artifact;
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = "Failed to deploy from URL: " + artifactAchivedUrl;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private void logDeploymentFailure(Throwable t, String artifactName) {
        String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy artifact '%s', see below", artifactName));
        logger.error((Object)msg, t);
    }

    @Override
    public Map<URL, Long> getArtifactsZombieMap() {
        HashMap<URL, Long> result = new HashMap<URL, Long>();
        for (String artifact : this.artifactZombieMap.keySet()) {
            ZombieFile file = this.artifactZombieMap.get(artifact);
            result.put(file.url, file.originalTimestamp);
        }
        return result;
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<T> artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeployArtifactWithoutUninstall(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (DeploymentException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), (Throwable)((Object)e));
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    @Override
    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    private T deployPackagedArtifact(URL artifactUrl, String artifactName) throws IOException {
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        if (zombieFile != null && zombieFile.isFor(artifactUrl) && !zombieFile.updatedZombieApp()) {
            return null;
        }
        Artifact artifact = (Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName));
        if (artifact != null) {
            this.undeployArtifact(artifactName);
        }
        return this.deployPackagedArtifact(artifactUrl);
    }

    private T deployExplodedApp(String addedApp) throws DeploymentException {
        T artifact;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("================== New Exploded Artifact: " + addedApp));
        }
        try {
            artifact = this.artifactFactory.createArtifact(addedApp);
            this.trackArtifact(artifact);
        }
        catch (Throwable t) {
            File artifactDir1 = this.artifactDir;
            File artifactDir = new File(artifactDir1, addedApp);
            this.addZombieFile(addedApp, artifactDir);
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy exploded artifact: '%s', see below", addedApp));
            logger.error((Object)msg, t);
            this.deploymentListener.onDeploymentFailure(addedApp, t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy artifact: " + addedApp;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
        this.deployArtifact(artifact);
        return artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardedDeploy(T artifact) {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            this.deployer.deploy(artifact);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    @Override
    public void deployArtifact(T artifact) throws DeploymentException {
        try {
            this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
            this.guardedDeploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.artifactZombieMap.remove(artifact.getArtifactName());
        }
        catch (Throwable t) {
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy artifact '%s', see below", artifact.getArtifactName()));
            logger.error((Object)msg, t);
            this.addZombieApp((Artifact)artifact);
            this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy artifact: " + artifact.getArtifactName();
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private void addZombieApp(Artifact artifact) {
        File resourceFile = artifact.getResourceFiles()[0];
        if (resourceFile.exists()) {
            try {
                this.artifactZombieMap.put(artifact.getArtifactName(), new ZombieFile(resourceFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addZombieFile(String artifactName, File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            this.artifactZombieMap.put(artifactName, new ZombieFile(marker));
        }
        catch (Exception e) {
            logger.debug((Object)String.format("Failed to mark an exploded artifact [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    private T findArtifact(String artifactName) {
        return (T)((Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName)));
    }

    private void trackArtifact(T artifact) {
        T previousArtifact = this.findArtifact(artifact.getArtifactName());
        this.artifacts.remove(previousArtifact);
        this.artifacts.add(artifact);
    }

    private void undeploy(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.artifacts.remove(artifact);
            this.guardedUndeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    private void logRequestToUndeployArtifact(T artifact) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("================== Request to Undeploy Artifact: " + artifact.getArtifactName()));
        }
    }

    private T guardedInstallFrom(URL artifactUrl) throws IOException {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                throw new IOException(ANOTHER_DEPLOYMENT_OPERATION_IS_IN_PROGRESS);
            }
            T t = this.installFrom(artifactUrl);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(INSTALL_OPERATION_HAS_BEEN_INTERRUPTED);
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    private T installFrom(URL url) throws IOException {
        String artifactName = this.artifactArchiveInstaller.installArtifact(url);
        return this.artifactFactory.createArtifact(artifactName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardedUndeploy(T artifact) {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            this.deployer.undeploy(artifact);
            this.artifactArchiveInstaller.desinstallArtifact(artifact.getArtifactName());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    @Override
    public void redeploy(T artifact) throws DeploymentException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)SplashScreen.miniSplash((String)String.format("Redeploying artifact '%s'", artifact.getArtifactName())));
        }
        this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
        try {
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
        }
        this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
        try {
            this.deployer.deploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable t) {
            try {
                this.logDeploymentFailure(t, artifact.getArtifactName());
                if (t instanceof DeploymentException) {
                    throw (DeploymentException)((Object)t);
                }
                String msg = "Failed to deploy artifact: " + artifact.getArtifactName();
                throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
            }
            catch (Throwable throwable) {
                this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
                throw throwable;
            }
        }
        this.artifactZombieMap.remove(artifact.getArtifactName());
    }

    private static class ZombieFile {
        URL url;
        Long originalTimestamp;
        File file;

        private ZombieFile(File file) {
            this.file = file;
            this.originalTimestamp = file.lastModified();
            try {
                this.url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean isFor(URL url) {
            return this.url.equals(url);
        }

        public boolean updatedZombieApp() {
            return this.originalTimestamp.longValue() != this.file.lastModified();
        }
    }
}

