/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.ArtifactArchiveInstaller;
import org.mule.module.launcher.ArtifactDeployer;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.application.NullDeploymentListener;
import org.mule.module.launcher.artifact.Artifact;
import org.mule.module.launcher.artifact.ArtifactFactory;
import org.mule.module.launcher.util.ObservableList;
import org.mule.util.CollectionUtils;
import org.mule.util.FileUtils;
import org.mule.util.SplashScreen;
import org.mule.util.StringUtils;

public class ArchiveDeployer<T extends Artifact> {
    public static final String ARTIFACT_NAME_PROPERTY = "artifactName";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    public static final String ANOTHER_DEPLOYMENT_OPERATION_IS_IN_PROGRESS = "Another deployment operation is in progress";
    public static final String INSTALL_OPERATION_HAS_BEEN_INTERRUPTED = "Install operation has been interrupted";
    private final transient Log logger = LogFactory.getLog(this.getClass());
    private final ArtifactDeployer<T> deployer;
    private final ArtifactArchiveInstaller artifactArchiveInstaller;
    private final ReentrantLock deploymentLock;
    private final Map<String, ZombieFile> artifactZombieMap = new HashMap<String, ZombieFile>();
    private final File artifactDir;
    private final ObservableList<T> artifacts;
    private ArtifactFactory<T> artifactFactory;
    private DeploymentListener deploymentListener = new NullDeploymentListener();

    public ArchiveDeployer(ArtifactDeployer deployer, ArtifactFactory artifactFactory, ObservableList<T> artifacts, ReentrantLock lock) {
        this.deployer = deployer;
        this.artifactFactory = artifactFactory;
        this.artifacts = artifacts;
        this.deploymentLock = lock;
        this.artifactDir = artifactFactory.getArtifactDir();
        this.artifactArchiveInstaller = new ArtifactArchiveInstaller(this.artifactDir);
    }

    public void deployPackagedArtifact(String zip) throws DeploymentException {
        try {
            String artifactName = StringUtils.removeEnd((String)zip, (String)ZIP_FILE_SUFFIX);
            File artifactZip = new File(this.artifactDir, zip);
            URL url = artifactZip.toURI().toURL();
            this.deployPackagedArtifact(url, artifactName);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(CoreMessages.createStaticMessage((String)("Failed to deploy from zip: " + zip)), e);
        }
    }

    public void deployExplodedArtifact(String artifactDir) throws DeploymentException {
        String artifactName = artifactDir;
        Collection deployedAppNames = CollectionUtils.collect(this.artifacts, (Transformer)new BeanToPropertyValueTransformer(ARTIFACT_NAME_PROPERTY));
        if (deployedAppNames.contains(artifactName) && !this.artifactZombieMap.containsKey(artifactName)) {
            return;
        }
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        if (zombieFile != null && !zombieFile.updatedZombieApp()) {
            return;
        }
        this.deployExplodedApp(artifactName);
    }

    public void undeployArtifact(String artifactDir) {
        if (this.artifactZombieMap.containsKey(artifactDir)) {
            return;
        }
        Artifact artifact = (Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactDir));
        this.undeploy(artifact);
    }

    public void deployPackagedArtifact(URL artifactAchivedUrl) throws DeploymentException {
        try {
            T artifact;
            try {
                artifact = this.guardedInstallFrom(artifactAchivedUrl);
                this.trackArtifact(artifact);
            }
            catch (Throwable t) {
                File artifactArchive = new File(artifactAchivedUrl.toURI());
                String artifactName = StringUtils.removeEnd((String)artifactArchive.getName(), (String)ZIP_FILE_SUFFIX);
                String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy artifact '%s', see below", artifactName));
                this.logger.error((Object)msg, t);
                this.addZombieFile(artifactName, artifactArchive);
                this.deploymentListener.onDeploymentFailure(artifactName, t);
                throw t;
            }
            this.deployArtifact(artifact);
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = "Failed to deploy from URL: " + artifactAchivedUrl;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    Map<URL, Long> getArtifactsZombieMap() {
        HashMap<URL, Long> result = new HashMap<URL, Long>();
        for (String artifact : this.artifactZombieMap.keySet()) {
            ZombieFile file = this.artifactZombieMap.get(artifact);
            result.put(file.url, file.lastUpdated);
        }
        return result;
    }

    void setArtifactFactory(ArtifactFactory<T> artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    private void deployPackagedArtifact(URL artifactUrl, String artifactName) throws IOException {
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        if (zombieFile != null && zombieFile.isFor(artifactUrl) && !zombieFile.updatedZombieApp()) {
            return;
        }
        Artifact artifact = (Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName));
        if (artifact != null) {
            this.undeployArtifact(artifactName);
        }
        this.deployPackagedArtifact(artifactUrl);
    }

    private void deployExplodedApp(String addedApp) throws DeploymentException {
        T artifact;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("================== New Exploded Artifact: " + addedApp));
        }
        try {
            artifact = this.artifactFactory.createArtifact(addedApp);
            this.trackArtifact(artifact);
        }
        catch (Throwable t) {
            File artifactDir1 = this.artifactDir;
            File artifactDir = new File(artifactDir1, addedApp);
            this.addZombieFile(addedApp, artifactDir);
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy exploded artifact: '%s', see below", addedApp));
            this.logger.error((Object)msg, t);
            this.deploymentListener.onDeploymentFailure(addedApp, t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy artifact: " + addedApp;
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
        this.deployArtifact(artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardedDeploy(T artifact) {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            this.deployer.deploy(artifact);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    private void deployArtifact(T artifact) throws DeploymentException {
        try {
            this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
            this.artifactArchiveInstaller.installExplodedArtifact(artifact.getArtifactName());
            this.guardedDeploy(artifact);
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.artifactZombieMap.remove(artifact.getArtifactName());
        }
        catch (Throwable t) {
            String msg = SplashScreen.miniSplash((String)String.format("Failed to deploy artifact '%s', see below", artifact.getArtifactName()));
            this.logger.error((Object)msg, t);
            this.addZombieApp((Artifact)artifact);
            this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            msg = "Failed to deploy artifact: " + artifact.getArtifactName();
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private void addZombieApp(Artifact artifact) {
        File resourceFile = artifact.getResourceFiles()[0];
        ZombieFile zombieFile = new ZombieFile();
        if (resourceFile.exists()) {
            try {
                zombieFile.url = resourceFile.toURI().toURL();
                zombieFile.lastUpdated = resourceFile.lastModified();
                this.artifactZombieMap.put(artifact.getArtifactName(), zombieFile);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    private void addZombieFile(String artifactName, File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            long lastModified = marker.lastModified();
            ZombieFile zombieFile = new ZombieFile();
            zombieFile.url = marker.toURI().toURL();
            zombieFile.lastUpdated = lastModified;
            this.artifactZombieMap.put(artifactName, zombieFile);
        }
        catch (MalformedURLException e) {
            this.logger.debug((Object)String.format("Failed to mark an exploded artifact [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    private T findArtifact(String artifactName) {
        return (T)((Artifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName)));
    }

    private void trackArtifact(T artifact) {
        T previousArtifact = this.findArtifact(artifact.getArtifactName());
        this.artifacts.remove(previousArtifact);
        this.artifacts.add(artifact);
    }

    private void undeploy(T artifact) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("================== Request to Undeploy Artifact: " + artifact.getArtifactName()));
        }
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.artifacts.remove(artifact);
            this.guardedUndeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    private T guardedInstallFrom(URL artifactUrl) throws IOException {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                throw new IOException(ANOTHER_DEPLOYMENT_OPERATION_IS_IN_PROGRESS);
            }
            T t = this.installFrom(artifactUrl);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(INSTALL_OPERATION_HAS_BEEN_INTERRUPTED);
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    private T installFrom(URL url) throws IOException {
        String artifactName = this.artifactArchiveInstaller.installArtifact(url);
        return this.artifactFactory.createArtifact(artifactName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardedUndeploy(T artifact) {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                return;
            }
            this.deployer.undeploy(artifact);
            this.artifactArchiveInstaller.desinstallArtifact(artifact.getArtifactName());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    public void redeploy(T artifact) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Redeploying app '%s'", artifact.getArtifactName())));
        }
        this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
        try {
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
        }
        this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
        try {
            this.deployer.deploy(artifact);
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable e) {
            this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), e);
        }
        this.artifactZombieMap.remove(artifact.getArtifactName());
    }

    private static class ZombieFile {
        URL url;
        Long lastUpdated;

        private ZombieFile() {
        }

        public boolean isFor(URL url) {
            return this.url.equals(url);
        }

        public boolean updatedZombieApp() {
            long currentTimeStamp = FileUtils.getFileTimeStamp((URL)this.url);
            return this.lastUpdated != currentTimeStamp;
        }
    }
}

