/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.MuleDeployer;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationFactory;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;

public class DefaultMuleDeployer
implements MuleDeployer {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected ApplicationFactory applicationFactory;

    public void setApplicationFactory(ApplicationFactory applicationFactory) {
        this.applicationFactory = applicationFactory;
    }

    @Override
    public void deploy(Application app) {
        try {
            app.install();
            app.init();
            app.start();
        }
        catch (Throwable t) {
            app.dispose();
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = String.format("Failed to deploy application [%s]", app.getAppName());
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    @Override
    public void undeploy(Application app) {
        try {
            this.tryToStopApp(app);
            this.tryToDisposeApp(app);
            File appDir = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), app.getAppName());
            FileUtils.deleteDirectory((File)appDir);
            File marker = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), String.format("%s-anchor.txt", app.getAppName()));
            marker.delete();
            Introspector.flushCaches();
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)((Object)t);
            }
            String msg = String.format("Failed to undeploy application [%s]", app.getAppName());
            throw new DeploymentException(MessageFactory.createStaticMessage((String)msg), t);
        }
    }

    private void tryToDisposeApp(Application app) {
        try {
            app.dispose();
        }
        catch (Throwable t) {
            this.logger.error((Object)String.format("Unable to cleanly dispose application '%s'. Restart Mule if you get errors redeploying this application", app.getAppName()), t);
        }
    }

    private void tryToStopApp(Application app) {
        if (!app.getMuleContext().getLifecycleManager().isDirectTransition("stop")) {
            return;
        }
        try {
            app.stop();
        }
        catch (Throwable t) {
            this.logger.error((Object)String.format("Unable to cleanly stop application '%s'. Restart Mule if you get errors redeploying this application", app.getAppName()), t);
        }
    }

    @Override
    public Application installFromAppDir(String packedMuleAppFileName) throws IOException {
        File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
        File appFile = new File(appsDir, packedMuleAppFileName);
        if (!appFile.getParentFile().equals(appsDir)) {
            throw new SecurityException("installFromAppDir() can only deploy from $MULE_HOME/apps. Use installFrom(url) instead.");
        }
        return this.installFrom(appFile.toURL());
    }

    @Override
    public Application installFrom(URL url) throws IOException {
        String appName;
        if (this.applicationFactory == null) {
            throw new IllegalStateException("There is no application factory");
        }
        if (!url.toString().endsWith(".zip")) {
            throw new IllegalArgumentException("Invalid Mule application archive: " + url);
        }
        String baseName = FilenameUtils.getBaseName((String)url.toString());
        if (baseName.contains("%20")) {
            throw new DeploymentInitException(MessageFactory.createStaticMessage((String)("Mule application name may not contain spaces: " + baseName)));
        }
        File appDir = null;
        boolean errorEncountered = false;
        try {
            File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
            String fullPath = url.toURI().toString();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Exploding a Mule application archive: " + fullPath));
            }
            appName = FilenameUtils.getBaseName((String)fullPath);
            appDir = new File(appsDir, appName);
            File source = new File(url.toURI());
            FileUtils.unzip((File)source, (File)appDir);
            if ("file".equals(url.getProtocol())) {
                FileUtils.deleteQuietly((File)source);
            }
        }
        catch (URISyntaxException e) {
            errorEncountered = true;
            IOException ex = new IOException(e.getMessage());
            ex.fillInStackTrace();
            throw ex;
        }
        catch (IOException e) {
            errorEncountered = true;
            throw e;
        }
        catch (Throwable t) {
            errorEncountered = true;
            String msg = "Failed to install app from URL: " + url;
            throw new DeploymentInitException(MessageFactory.createStaticMessage((String)msg), t);
        }
        finally {
            if (errorEncountered && appDir != null && appDir.exists()) {
                boolean couldNotDelete = FileUtils.deleteTree((File)appDir);
            }
        }
        return this.applicationFactory.createApp(appName);
    }
}

