/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import org.mule.api.config.ThreadingProfile;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.util.StringUtils;
import org.mule.work.MuleWorkManager;

public class ApplicationMuleContextBuilder
extends DefaultMuleContextBuilder {
    protected ApplicationDescriptor desc;

    public ApplicationMuleContextBuilder(ApplicationDescriptor desc) {
        this.desc = desc;
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration(true);
        configuration.setId(this.desc.getAppName());
        String encoding = this.desc.getEncoding();
        if (StringUtils.isNotBlank((String)encoding)) {
            configuration.setDefaultEncoding(encoding);
        }
        return configuration;
    }

    protected MuleWorkManager createWorkManager() {
        String threadName = String.format("Mule[%s]", this.desc.getAppName());
        return new MuleWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, threadName, this.getMuleConfiguration().getShutdownTimeout());
    }
}

