/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.module.launcher.ConfigChangeMonitorThreadFactory;
import org.mule.module.launcher.DefaultMuleSharedDomainClassLoader;
import org.mule.module.launcher.Deployer;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.DeploymentStopException;
import org.mule.module.launcher.FileWatcher;
import org.mule.module.launcher.MuleApplicationClassLoader;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleAppDeployer
implements Deployer<Map<String, Object>> {
    public static final String DEFAULT_CONFIGURATION = "mule-config.xml";
    protected static final int DEFAULT_RELOAD_CHECK_INTERVAL_MS = 3000;
    protected static final String CLASSNAME_DEFAULT_CONFIG_BUILDER = "org.mule.config.builders.AutoConfigurationBuilder";
    protected static final String CLASSNAME_SPRING_CONFIG_BUILDER = "org.mule.config.spring.SpringXmlConfigurationBuilder";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected ScheduledExecutorService watchTimer;
    private String appName;
    private Map<String, Object> metaData;
    private String configBuilderClassName;
    protected URL configUrl;
    private MuleContext muleContext;
    private ClassLoader deploymentClassLoader;
    private boolean redeploymentEnabled = true;

    public MuleAppDeployer(String appName) {
        this.appName = appName;
    }

    @Override
    public void install() {
        String builder;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Installing application: " + this.appName));
        }
        String muleHome = System.getProperty("mule.home");
        String configPath = String.format("%s/apps/%s/%s", muleHome, this.getAppName(), DEFAULT_CONFIGURATION);
        this.configUrl = IOUtils.getResourceAsUrl((String)configPath, this.getClass(), (boolean)true, (boolean)false);
        if (this.configUrl == null) {
            System.out.println(CoreMessages.configNotFoundUsage());
            System.exit(-1);
        }
        if (StringUtils.isBlank((String)(builder = (String)this.metaData.get("builder")))) {
            builder = CLASSNAME_DEFAULT_CONFIG_BUILDER;
        }
        try {
            this.configBuilderClassName = "spring".equalsIgnoreCase(builder) ? CLASSNAME_SPRING_CONFIG_BUILDER : builder;
        }
        catch (Exception e) {
            this.logger.fatal((Object)e);
            Message message = CoreMessages.failedToLoad((String)("Builder: " + this.configBuilderClassName));
            System.err.println(StringMessageUtils.getBoilerPlate((String)("FATAL: " + message.toString())));
            System.exit(1);
        }
        this.createDeploymentClassLoader();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting application: " + this.appName));
        }
        try {
            this.muleContext.start();
        }
        catch (MuleException e) {
            throw new DeploymentStartException(MessageFactory.createStaticMessage((String)this.appName), e);
        }
    }

    @Override
    public void init() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initializing application: " + this.appName));
        }
        try {
            ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)ClassUtils.instanciateClass((String)this.configBuilderClassName, (Object[])new Object[]{this.configUrl.toExternalForm()}, (ClassLoader)this.getDeploymentClassLoader());
            if (!cfgBuilder.isConfigured()) {
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                this.muleContext = muleContextFactory.createMuleContext(cfgBuilder);
                if (this.redeploymentEnabled) {
                    this.createRedeployMonitor();
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentInitException(CoreMessages.failedToLoad((String)this.configBuilderClassName), e);
        }
    }

    @Override
    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public ClassLoader getDeploymentClassLoader() {
        return this.deploymentClassLoader;
    }

    @Override
    public void dispose() {
        if (this.muleContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"MuleContext not created, nothing to dispose of");
            }
            return;
        }
        if (this.muleContext.isStarted() && !this.muleContext.isDisposed()) {
            this.stop();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing application: " + this.appName));
        }
        this.muleContext.dispose();
        Thread.currentThread().setContextClassLoader(null);
    }

    @Override
    public void redeploy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Redeploying application: " + this.appName));
        }
        this.dispose();
        this.install();
        ClassLoader cl = this.getDeploymentClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        this.init();
        this.start();
    }

    @Override
    public void stop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping application: " + this.appName));
        }
        try {
            this.muleContext.stop();
        }
        catch (MuleException e) {
            throw new DeploymentStopException(MessageFactory.createStaticMessage((String)this.appName), e);
        }
    }

    public boolean isRedeploymentEnabled() {
        return this.redeploymentEnabled;
    }

    public void setRedeploymentEnabled(boolean redeploymentEnabled) {
        this.redeploymentEnabled = redeploymentEnabled;
    }

    protected void createDeploymentClassLoader() {
        DefaultMuleSharedDomainClassLoader parent = new DefaultMuleSharedDomainClassLoader(this.getClass().getClassLoader());
        this.deploymentClassLoader = new MuleApplicationClassLoader(this.appName, new File(this.configUrl.getFile()), (ClassLoader)parent);
    }

    protected void createRedeployMonitor() throws NotificationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Monitoring for hot-deployment: " + this.configUrl.toExternalForm()));
        }
        final ConfigFileWatcher watcher = new ConfigFileWatcher(new File(this.configUrl.getFile()));
        this.muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

            public void onNotification(MuleContextNotification notification) {
                int action = notification.getAction();
                switch (action) {
                    case 104: {
                        MuleAppDeployer.this.scheduleConfigMonitor(watcher);
                        break;
                    }
                    case 105: {
                        MuleAppDeployer.this.watchTimer.shutdownNow();
                        MuleAppDeployer.this.muleContext.unregisterListener((ServerNotificationListener)this);
                    }
                }
            }
        });
    }

    protected void scheduleConfigMonitor(FileWatcher watcher) {
        int reloadIntervalMs = 3000;
        this.watchTimer = Executors.newSingleThreadScheduledExecutor(new ConfigChangeMonitorThreadFactory(this.appName));
        this.watchTimer.scheduleWithFixedDelay(watcher, 3000L, 3000L, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Reload interval: 3000");
        }
    }

    protected class ConfigFileWatcher
    extends FileWatcher {
        public ConfigFileWatcher(File watchedResource) {
            super(watchedResource);
        }

        protected synchronized void onChange(File file) {
            if (MuleAppDeployer.this.logger.isInfoEnabled()) {
                MuleAppDeployer.this.logger.info((Object)("================== Reloading " + file));
            }
            ClassLoader cl = MuleAppDeployer.this.getDeploymentClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            MuleAppDeployer.this.redeploy();
        }
    }
}

