/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.json.JsonData;
import org.mule.module.json.transformers.AbstractJsonTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

public class JsonToObject
extends AbstractJsonTransformer {
    private static final DataType<JsonData> JSON_TYPE = DataTypeFactory.create(JsonData.class, (String)"application/json");
    private Map<Class<?>, Class<?>> deserializationMixins = new HashMap();

    public JsonToObject() {
        this.registerSourceType(DataTypeFactory.create(Reader.class));
        this.registerSourceType(DataTypeFactory.create(URL.class));
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(JSON_TYPE);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        for (Map.Entry<Class<?>, Class<?>> entry : this.getMixins().entrySet()) {
            this.getMapper().getDeserializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Class<?>> entry : this.deserializationMixins.entrySet()) {
            this.getMapper().getDeserializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        JsonData jsonData;
        Object src = message.getPayload();
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            Object returnValue;
            if (src instanceof InputStream) {
                is = (InputStream)src;
            } else if (src instanceof File) {
                is = new FileInputStream((File)src);
            } else if (src instanceof URL) {
                is = ((URL)src).openStream();
            } else if (src instanceof byte[]) {
                is = new ByteArrayInputStream((byte[])src);
            }
            if (src instanceof Reader) {
                returnValue = this.getReturnDataType().equals(JSON_TYPE) ? new JsonData((Reader)src) : this.getMapper().readValue((Reader)src, this.getReturnDataType().getType());
            } else if (src instanceof String) {
                returnValue = this.getReturnDataType().equals(JSON_TYPE) ? new JsonData((String)src) : this.getMapper().readValue((String)src, this.getReturnDataType().getType());
            } else {
                reader = new InputStreamReader(is, outputEncoding);
                returnValue = this.getReturnDataType().equals(JSON_TYPE) ? new JsonData(reader) : this.getMapper().readValue((Reader)reader, this.getReturnDataType().getType());
            }
            jsonData = returnValue;
        }
        catch (Exception e) {
            try {
                throw new TransformerException(CoreMessages.transformFailed((String)"json", (String)this.getReturnDataType().getType().getName()), (Transformer)this, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)is);
        return jsonData;
    }

    public Map<Class<?>, Class<?>> getDeserializationMixins() {
        return this.deserializationMixins;
    }

    public void setDeserializationMixins(Map<Class<?>, Class<?>> deserializationMixins) {
        this.deserializationMixins = deserializationMixins;
    }
}

