/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;

public class TransformerInputs {
    private InputStream is;
    private Reader reader;

    TransformerInputs(Transformer xform, Object src) throws TransformerException {
        try {
            if (src instanceof InputStream) {
                this.is = (InputStream)src;
            } else if (src instanceof File) {
                this.is = new FileInputStream((File)src);
            } else if (src instanceof URL) {
                this.is = ((URL)src).openStream();
            } else if (src instanceof byte[]) {
                this.is = new ByteArrayInputStream((byte[])src);
            } else if (src instanceof Reader) {
                this.reader = (Reader)src;
            } else if (src instanceof String) {
                this.reader = new StringReader((String)src);
            }
            if (this.is != null || this.reader != null) {
                return;
            }
        }
        catch (IOException ex) {
            throw new TransformerException(xform, (Throwable)ex);
        }
        throw new TransformerException(CoreMessages.transformFailed((String)src.getClass().getName(), (String)"xml"));
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public Reader getReader() {
        return this.reader;
    }
}

