/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.Dereferencing;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfigurationBuilder;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.json.DefaultJsonParser;
import org.mule.module.json.validation.JsonSchemaDereferencing;
import org.mule.module.json.validation.JsonSchemaValidationException;
import org.mule.util.Preconditions;

public class JsonSchemaValidator {
    private final JsonSchema schema;

    public static Builder builder() {
        return new Builder();
    }

    private JsonSchemaValidator(JsonSchema schema) {
        this.schema = schema;
    }

    public void validate(MuleEvent event) throws MuleException {
        ProcessingReport report;
        Object input = event.getMessage().getPayload();
        JsonNode jsonNode = null;
        try {
            jsonNode = new DefaultJsonParser(event.getMuleContext()).asJsonNode(input);
            if (input instanceof Reader || input instanceof InputStream) {
                event.getMessage().setPayload((Object)jsonNode.toString());
            }
            report = this.schema.validate(jsonNode);
        }
        catch (Exception e) {
            throw new JsonSchemaValidationException("Exception was found while trying to validate json schema", jsonNode == null ? "" : jsonNode.toString(), e);
        }
        if (!report.isSuccess()) {
            throw new JsonSchemaValidationException("Json content is not compliant with schema\n" + report.toString(), jsonNode.toString());
        }
    }

    public static final class Builder {
        private String schemaLocation;
        private JsonSchemaDereferencing dereferencing = JsonSchemaDereferencing.CANONICAL;
        private final Map<String, String> schemaRedirects = new HashMap<String, String>();

        private Builder() {
        }

        public Builder setSchemaLocation(String schemaLocation) {
            Preconditions.checkArgument((!StringUtils.isBlank((String)schemaLocation) ? 1 : 0) != 0, (String)"schemaLocation cannot be null or blank");
            this.schemaLocation = this.formatUri(schemaLocation);
            return this;
        }

        public Builder setDereferencing(JsonSchemaDereferencing dereferencing) {
            Preconditions.checkArgument((dereferencing != null ? 1 : 0) != 0, (String)"dereferencing cannot be null");
            this.dereferencing = dereferencing;
            return this;
        }

        public Builder addSchemaRedirect(String from, String to) {
            Preconditions.checkArgument((!StringUtils.isBlank((String)from) ? 1 : 0) != 0, (String)"from cannot be null or blank");
            Preconditions.checkArgument((!StringUtils.isBlank((String)to) ? 1 : 0) != 0, (String)"to cannot be null or blank");
            this.schemaRedirects.put(this.formatUri(from), this.formatUri(to));
            return this;
        }

        public Builder addSchemaRedirects(Map<String, String> redirects) {
            for (Map.Entry<String, String> redirect : redirects.entrySet()) {
                this.addSchemaRedirect(redirect.getKey(), redirect.getValue());
            }
            return this;
        }

        public JsonSchemaValidator build() {
            Preconditions.checkState((this.schemaLocation != null ? 1 : 0) != 0, (String)"schemaLocation has not been provided");
            URITranslatorConfigurationBuilder translatorConfigurationBuilder = URITranslatorConfiguration.newBuilder();
            for (Map.Entry<String, String> redirect : this.schemaRedirects.entrySet()) {
                translatorConfigurationBuilder.addSchemaRedirect(redirect.getKey(), redirect.getValue());
            }
            LoadingConfigurationBuilder loadingConfigurationBuilder = LoadingConfiguration.newBuilder().dereferencing(this.dereferencing == JsonSchemaDereferencing.CANONICAL ? Dereferencing.CANONICAL : Dereferencing.INLINE).setURITranslatorConfiguration(translatorConfigurationBuilder.freeze());
            JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(loadingConfigurationBuilder.freeze()).freeze();
            try {
                return new JsonSchemaValidator(factory.getJsonSchema(this.schemaLocation));
            }
            catch (ProcessingException e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not initialise JsonSchemaValidator"), (Throwable)e);
            }
        }

        private String formatUri(String location) {
            URI uri = URI.create(location);
            if (uri.getScheme() == null) {
                if (location.charAt(0) == '/') {
                    location = location.substring(1);
                }
                location = "resource:/" + location;
            }
            return location;
        }
    }
}

