/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.ValueNode;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.json.JsonData;
import org.mule.util.NumberUtils;

public class JsonExpressionEvaluator
implements ExpressionEvaluator {
    protected final transient Log logger = LogFactory.getLog(JsonExpressionEvaluator.class);

    public Object evaluate(String expression, MuleMessage message) {
        String compareTo = null;
        boolean not = false;
        int start = expression.lastIndexOf("/");
        if (start == -1) {
            start = 0;
        }
        int i = 0;
        i = expression.indexOf("!=", start);
        if (i > -1) {
            compareTo = expression.substring(i + 2, expression.length()).trim();
            expression = expression.substring(0, i).trim();
            not = true;
        } else {
            i = expression.indexOf("=", start);
            if (i > -1) {
                compareTo = expression.substring(i + 1, expression.length()).trim();
                expression = expression.substring(0, i).trim();
            }
        }
        try {
            String json = message.getPayloadAsString();
            JsonData data = new JsonData(json);
            try {
                JsonNode resultNode = data.get(expression);
                if (compareTo != null) {
                    Object resultValue;
                    Object object = resultValue = resultNode.isValueNode() ? resultNode.asText() : resultNode;
                    if (compareTo.equalsIgnoreCase("null")) {
                        boolean answer;
                        boolean bl = answer = resultValue == null;
                        return not ? !answer : answer;
                    }
                    if (resultValue instanceof Number && NumberUtils.isDigits((String)compareTo)) {
                        boolean answer = NumberUtils.createNumber((String)compareTo).equals(resultValue);
                        return not ? !answer : answer;
                    }
                    if (resultValue instanceof Boolean && (compareTo.equalsIgnoreCase("true") || compareTo.equalsIgnoreCase("false"))) {
                        boolean answer = resultValue.equals(Boolean.valueOf(compareTo));
                        return not ? !answer : answer;
                    }
                    boolean answer = compareTo.equals(resultValue);
                    return not ? !answer : answer;
                }
                return this.extractResultFromNode(resultNode);
            }
            catch (IllegalArgumentException e) {
                if (compareTo == null) {
                    this.logger.debug((Object)("returning null for json expression: " + expression + ": " + e.getMessage()));
                    return null;
                }
                return compareTo.equalsIgnoreCase("null") & !not;
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction((String)(this.getName() + ":" + expression)), (Throwable)e);
        }
    }

    protected Object extractResultFromNode(JsonNode result) {
        if (result instanceof ValueNode) {
            return result.asText();
        }
        if (result instanceof ObjectNode) {
            return ((ObjectNode)result).toString();
        }
        if (result instanceof ArrayNode) {
            ArrayList<Object> parts = new ArrayList<Object>();
            Iterator i = result.getElements();
            while (i.hasNext()) {
                JsonNode arrayNode = (JsonNode)i.next();
                parts.add(this.extractResultFromNode(arrayNode));
            }
            return parts;
        }
        return result;
    }

    public String getName() {
        return "json";
    }
}

